/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.redshift.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.redshift.model.Subnet;
import com.amazonaws.services.redshift.model.Tag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ClusterSubnetGroup
implements Serializable {
    private String clusterSubnetGroupName;
    private String description;
    private String vpcId;
    private String subnetGroupStatus;
    private ListWithAutoConstructFlag<Subnet> subnets;
    private ListWithAutoConstructFlag<Tag> tags;

    public String getClusterSubnetGroupName() {
        return this.clusterSubnetGroupName;
    }

    public void setClusterSubnetGroupName(String clusterSubnetGroupName) {
        this.clusterSubnetGroupName = clusterSubnetGroupName;
    }

    public ClusterSubnetGroup withClusterSubnetGroupName(String clusterSubnetGroupName) {
        this.clusterSubnetGroupName = clusterSubnetGroupName;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ClusterSubnetGroup withDescription(String description) {
        this.description = description;
        return this;
    }

    public String getVpcId() {
        return this.vpcId;
    }

    public void setVpcId(String vpcId) {
        this.vpcId = vpcId;
    }

    public ClusterSubnetGroup withVpcId(String vpcId) {
        this.vpcId = vpcId;
        return this;
    }

    public String getSubnetGroupStatus() {
        return this.subnetGroupStatus;
    }

    public void setSubnetGroupStatus(String subnetGroupStatus) {
        this.subnetGroupStatus = subnetGroupStatus;
    }

    public ClusterSubnetGroup withSubnetGroupStatus(String subnetGroupStatus) {
        this.subnetGroupStatus = subnetGroupStatus;
        return this;
    }

    public List<Subnet> getSubnets() {
        if (this.subnets == null) {
            this.subnets = new ListWithAutoConstructFlag();
            this.subnets.setAutoConstruct(true);
        }
        return this.subnets;
    }

    public void setSubnets(Collection<Subnet> subnets) {
        if (subnets == null) {
            this.subnets = null;
            return;
        }
        ListWithAutoConstructFlag subnetsCopy = new ListWithAutoConstructFlag(subnets.size());
        subnetsCopy.addAll(subnets);
        this.subnets = subnetsCopy;
    }

    public ClusterSubnetGroup withSubnets(Subnet ... subnets) {
        if (this.getSubnets() == null) {
            this.setSubnets(new ArrayList<Subnet>(subnets.length));
        }
        for (Subnet value : subnets) {
            this.getSubnets().add(value);
        }
        return this;
    }

    public ClusterSubnetGroup withSubnets(Collection<Subnet> subnets) {
        if (subnets == null) {
            this.subnets = null;
        } else {
            ListWithAutoConstructFlag subnetsCopy = new ListWithAutoConstructFlag(subnets.size());
            subnetsCopy.addAll(subnets);
            this.subnets = subnetsCopy;
        }
        return this;
    }

    public List<Tag> getTags() {
        if (this.tags == null) {
            this.tags = new ListWithAutoConstructFlag();
            this.tags.setAutoConstruct(true);
        }
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        ListWithAutoConstructFlag tagsCopy = new ListWithAutoConstructFlag(tags.size());
        tagsCopy.addAll(tags);
        this.tags = tagsCopy;
    }

    public ClusterSubnetGroup withTags(Tag ... tags) {
        if (this.getTags() == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag value : tags) {
            this.getTags().add(value);
        }
        return this;
    }

    public ClusterSubnetGroup withTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
        } else {
            ListWithAutoConstructFlag tagsCopy = new ListWithAutoConstructFlag(tags.size());
            tagsCopy.addAll(tags);
            this.tags = tagsCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getClusterSubnetGroupName() != null) {
            sb.append("ClusterSubnetGroupName: " + this.getClusterSubnetGroupName() + ",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: " + this.getDescription() + ",");
        }
        if (this.getVpcId() != null) {
            sb.append("VpcId: " + this.getVpcId() + ",");
        }
        if (this.getSubnetGroupStatus() != null) {
            sb.append("SubnetGroupStatus: " + this.getSubnetGroupStatus() + ",");
        }
        if (this.getSubnets() != null) {
            sb.append("Subnets: " + this.getSubnets() + ",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: " + this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getClusterSubnetGroupName() == null ? 0 : this.getClusterSubnetGroupName().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getVpcId() == null ? 0 : this.getVpcId().hashCode());
        hashCode = 31 * hashCode + (this.getSubnetGroupStatus() == null ? 0 : this.getSubnetGroupStatus().hashCode());
        hashCode = 31 * hashCode + (this.getSubnets() == null ? 0 : this.getSubnets().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClusterSubnetGroup)) {
            return false;
        }
        ClusterSubnetGroup other = (ClusterSubnetGroup)obj;
        if (other.getClusterSubnetGroupName() == null ^ this.getClusterSubnetGroupName() == null) {
            return false;
        }
        if (other.getClusterSubnetGroupName() != null && !other.getClusterSubnetGroupName().equals(this.getClusterSubnetGroupName())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getVpcId() == null ^ this.getVpcId() == null) {
            return false;
        }
        if (other.getVpcId() != null && !other.getVpcId().equals(this.getVpcId())) {
            return false;
        }
        if (other.getSubnetGroupStatus() == null ^ this.getSubnetGroupStatus() == null) {
            return false;
        }
        if (other.getSubnetGroupStatus() != null && !other.getSubnetGroupStatus().equals(this.getSubnetGroupStatus())) {
            return false;
        }
        if (other.getSubnets() == null ^ this.getSubnets() == null) {
            return false;
        }
        if (other.getSubnets() != null && !other.getSubnets().equals(this.getSubnets())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }
}

