/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.redshift.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.redshift.model.DeleteClusterRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DeleteClusterRequestMarshaller
implements Marshaller<Request<DeleteClusterRequest>, DeleteClusterRequest> {
    @Override
    public Request<DeleteClusterRequest> marshall(DeleteClusterRequest deleteClusterRequest) {
        if (deleteClusterRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DeleteClusterRequest> request = new DefaultRequest<DeleteClusterRequest>(deleteClusterRequest, "AmazonRedshift");
        request.addParameter("Action", "DeleteCluster");
        request.addParameter("Version", "2012-12-01");
        if (deleteClusterRequest.getClusterIdentifier() != null) {
            request.addParameter("ClusterIdentifier", StringUtils.fromString(deleteClusterRequest.getClusterIdentifier()));
        }
        if (deleteClusterRequest.isSkipFinalClusterSnapshot() != null) {
            request.addParameter("SkipFinalClusterSnapshot", StringUtils.fromBoolean(deleteClusterRequest.isSkipFinalClusterSnapshot()));
        }
        if (deleteClusterRequest.getFinalClusterSnapshotIdentifier() != null) {
            request.addParameter("FinalClusterSnapshotIdentifier", StringUtils.fromString(deleteClusterRequest.getFinalClusterSnapshotIdentifier()));
        }
        return request;
    }
}

