/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.redshift.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.redshift.model.DescribeClusterSubnetGroupsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class DescribeClusterSubnetGroupsRequestMarshaller
implements Marshaller<Request<DescribeClusterSubnetGroupsRequest>, DescribeClusterSubnetGroupsRequest> {
    @Override
    public Request<DescribeClusterSubnetGroupsRequest> marshall(DescribeClusterSubnetGroupsRequest describeClusterSubnetGroupsRequest) {
        if (describeClusterSubnetGroupsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeClusterSubnetGroupsRequest> request = new DefaultRequest<DescribeClusterSubnetGroupsRequest>(describeClusterSubnetGroupsRequest, "AmazonRedshift");
        request.addParameter("Action", "DescribeClusterSubnetGroups");
        request.addParameter("Version", "2012-12-01");
        if (describeClusterSubnetGroupsRequest.getClusterSubnetGroupName() != null) {
            request.addParameter("ClusterSubnetGroupName", StringUtils.fromString(describeClusterSubnetGroupsRequest.getClusterSubnetGroupName()));
        }
        if (describeClusterSubnetGroupsRequest.getMaxRecords() != null) {
            request.addParameter("MaxRecords", StringUtils.fromInteger(describeClusterSubnetGroupsRequest.getMaxRecords()));
        }
        if (describeClusterSubnetGroupsRequest.getMarker() != null) {
            request.addParameter("Marker", StringUtils.fromString(describeClusterSubnetGroupsRequest.getMarker()));
        }
        List<String> tagKeysList = describeClusterSubnetGroupsRequest.getTagKeys();
        int tagKeysListIndex = 1;
        for (String tagKeysListValue : tagKeysList) {
            if (tagKeysListValue != null) {
                request.addParameter("TagKeys.TagKey." + tagKeysListIndex, StringUtils.fromString(tagKeysListValue));
            }
            ++tagKeysListIndex;
        }
        List<String> tagValuesList = describeClusterSubnetGroupsRequest.getTagValues();
        int tagValuesListIndex = 1;
        for (String tagValuesListValue : tagValuesList) {
            if (tagValuesListValue != null) {
                request.addParameter("TagValues.TagValue." + tagValuesListIndex, StringUtils.fromString(tagValuesListValue));
            }
            ++tagValuesListIndex;
        }
        return request;
    }
}

