/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.route53.model.transform;

import com.amazonaws.services.route53.model.CloudWatchAlarmConfiguration;
import com.amazonaws.services.route53.model.Dimension;
import com.amazonaws.services.route53.model.transform.DimensionStaxUnmarshaller;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;

public class CloudWatchAlarmConfigurationStaxUnmarshaller
implements Unmarshaller<CloudWatchAlarmConfiguration, StaxUnmarshallerContext> {
    private static CloudWatchAlarmConfigurationStaxUnmarshaller instance;

    public CloudWatchAlarmConfiguration unmarshall(StaxUnmarshallerContext context) throws Exception {
        CloudWatchAlarmConfiguration cloudWatchAlarmConfiguration = new CloudWatchAlarmConfiguration();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return cloudWatchAlarmConfiguration;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("EvaluationPeriods", targetDepth)) {
                    cloudWatchAlarmConfiguration.setEvaluationPeriods(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Threshold", targetDepth)) {
                    cloudWatchAlarmConfiguration.setThreshold(SimpleTypeStaxUnmarshallers.DoubleStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ComparisonOperator", targetDepth)) {
                    cloudWatchAlarmConfiguration.setComparisonOperator(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Period", targetDepth)) {
                    cloudWatchAlarmConfiguration.setPeriod(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("MetricName", targetDepth)) {
                    cloudWatchAlarmConfiguration.setMetricName(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Namespace", targetDepth)) {
                    cloudWatchAlarmConfiguration.setNamespace(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Statistic", targetDepth)) {
                    cloudWatchAlarmConfiguration.setStatistic(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Dimensions", targetDepth)) {
                    cloudWatchAlarmConfiguration.withDimensions(new ArrayList<Dimension>());
                    continue;
                }
                if (!context.testExpression("Dimensions/Dimension", targetDepth)) continue;
                cloudWatchAlarmConfiguration.withDimensions(DimensionStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return cloudWatchAlarmConfiguration;
    }

    public static CloudWatchAlarmConfigurationStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new CloudWatchAlarmConfigurationStaxUnmarshaller();
        }
        return instance;
    }
}

