/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.route53.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.route53.model.CreateHostedZoneRequest;
import com.amazonaws.services.route53.model.HostedZoneConfig;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.XMLWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;

public class CreateHostedZoneRequestMarshaller
implements Marshaller<Request<CreateHostedZoneRequest>, CreateHostedZoneRequest> {
    public Request<CreateHostedZoneRequest> marshall(CreateHostedZoneRequest createHostedZoneRequest) {
        HostedZoneConfig hostedZoneConfigHostedZoneConfig;
        if (createHostedZoneRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createHostedZoneRequest, "AmazonRoute53");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/2013-04-01/hostedzone";
        if (uriResourcePath.contains("?")) {
            String queryString = uriResourcePath.substring(uriResourcePath.indexOf("?") + 1);
            uriResourcePath = uriResourcePath.substring(0, uriResourcePath.indexOf("?"));
            for (String s : queryString.split("[;&]")) {
                String[] nameValuePair = s.split("=");
                if (nameValuePair.length == 2) {
                    request.addParameter(nameValuePair[0], nameValuePair[1]);
                    continue;
                }
                request.addParameter(s, null);
            }
        }
        request.setResourcePath(uriResourcePath);
        StringWriter stringWriter = new StringWriter();
        XMLWriter xmlWriter = new XMLWriter((Writer)stringWriter, "https://route53.amazonaws.com/doc/2013-04-01/");
        xmlWriter.startElement("CreateHostedZoneRequest");
        if (createHostedZoneRequest.getName() != null) {
            xmlWriter.startElement("Name").value(createHostedZoneRequest.getName()).endElement();
        }
        if (createHostedZoneRequest.getCallerReference() != null) {
            xmlWriter.startElement("CallerReference").value(createHostedZoneRequest.getCallerReference()).endElement();
        }
        if (createHostedZoneRequest != null && (hostedZoneConfigHostedZoneConfig = createHostedZoneRequest.getHostedZoneConfig()) != null) {
            xmlWriter.startElement("HostedZoneConfig");
            if (hostedZoneConfigHostedZoneConfig.getComment() != null) {
                xmlWriter.startElement("Comment").value(hostedZoneConfigHostedZoneConfig.getComment()).endElement();
            }
            xmlWriter.endElement();
        }
        xmlWriter.endElement();
        try {
            request.setContent((InputStream)new StringInputStream(stringWriter.getBuffer().toString()));
            request.addHeader("Content-Length", Integer.toString(stringWriter.getBuffer().toString().getBytes(StringUtils.UTF8).length));
            request.addHeader("Content-Type", "application/xml");
        }
        catch (UnsupportedEncodingException e) {
            throw new AmazonClientException("Unable to marshall request to XML", (Throwable)e);
        }
        return request;
    }

    private String getString(String s) {
        if (s == null) {
            return "";
        }
        return s;
    }
}

