/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleemail.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.simpleemail.model.AddHeaderAction;
import com.amazonaws.services.simpleemail.model.BounceAction;
import com.amazonaws.services.simpleemail.model.CreateReceiptRuleRequest;
import com.amazonaws.services.simpleemail.model.LambdaAction;
import com.amazonaws.services.simpleemail.model.ReceiptAction;
import com.amazonaws.services.simpleemail.model.ReceiptRule;
import com.amazonaws.services.simpleemail.model.S3Action;
import com.amazonaws.services.simpleemail.model.SNSAction;
import com.amazonaws.services.simpleemail.model.StopAction;
import com.amazonaws.services.simpleemail.model.WorkmailAction;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class CreateReceiptRuleRequestMarshaller
implements Marshaller<Request<CreateReceiptRuleRequest>, CreateReceiptRuleRequest> {
    public Request<CreateReceiptRuleRequest> marshall(CreateReceiptRuleRequest createReceiptRuleRequest) {
        ReceiptRule rule;
        if (createReceiptRuleRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createReceiptRuleRequest, "AmazonSimpleEmailService");
        request.addParameter("Action", "CreateReceiptRule");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (createReceiptRuleRequest.getRuleSetName() != null) {
            request.addParameter("RuleSetName", StringUtils.fromString((String)createReceiptRuleRequest.getRuleSetName()));
        }
        if (createReceiptRuleRequest.getAfter() != null) {
            request.addParameter("After", StringUtils.fromString((String)createReceiptRuleRequest.getAfter()));
        }
        if ((rule = createReceiptRuleRequest.getRule()) != null) {
            SdkInternalList actionsList;
            SdkInternalList recipientsList;
            if (rule.getName() != null) {
                request.addParameter("Rule.Name", StringUtils.fromString((String)rule.getName()));
            }
            if (rule.getEnabled() != null) {
                request.addParameter("Rule.Enabled", StringUtils.fromBoolean((Boolean)rule.getEnabled()));
            }
            if (rule.getTlsPolicy() != null) {
                request.addParameter("Rule.TlsPolicy", StringUtils.fromString((String)rule.getTlsPolicy()));
            }
            if (!(recipientsList = (SdkInternalList)rule.getRecipients()).isEmpty() || !recipientsList.isAutoConstruct()) {
                int recipientsListIndex = 1;
                for (String recipientsListValue : recipientsList) {
                    if (recipientsListValue != null) {
                        request.addParameter("Rule.Recipients.member." + recipientsListIndex, StringUtils.fromString((String)recipientsListValue));
                    }
                    ++recipientsListIndex;
                }
            }
            if (!(actionsList = (SdkInternalList)rule.getActions()).isEmpty() || !actionsList.isAutoConstruct()) {
                int actionsListIndex = 1;
                for (ReceiptAction actionsListValue : actionsList) {
                    SNSAction sNSAction;
                    AddHeaderAction addHeaderAction;
                    StopAction stopAction;
                    LambdaAction lambdaAction;
                    WorkmailAction workmailAction;
                    BounceAction bounceAction;
                    S3Action s3Action = actionsListValue.getS3Action();
                    if (s3Action != null) {
                        if (s3Action.getTopicArn() != null) {
                            request.addParameter("Rule.Actions.member." + actionsListIndex + ".S3Action.TopicArn", StringUtils.fromString((String)s3Action.getTopicArn()));
                        }
                        if (s3Action.getBucketName() != null) {
                            request.addParameter("Rule.Actions.member." + actionsListIndex + ".S3Action.BucketName", StringUtils.fromString((String)s3Action.getBucketName()));
                        }
                        if (s3Action.getObjectKeyPrefix() != null) {
                            request.addParameter("Rule.Actions.member." + actionsListIndex + ".S3Action.ObjectKeyPrefix", StringUtils.fromString((String)s3Action.getObjectKeyPrefix()));
                        }
                        if (s3Action.getKmsKeyArn() != null) {
                            request.addParameter("Rule.Actions.member." + actionsListIndex + ".S3Action.KmsKeyArn", StringUtils.fromString((String)s3Action.getKmsKeyArn()));
                        }
                    }
                    if ((bounceAction = actionsListValue.getBounceAction()) != null) {
                        if (bounceAction.getTopicArn() != null) {
                            request.addParameter("Rule.Actions.member." + actionsListIndex + ".BounceAction.TopicArn", StringUtils.fromString((String)bounceAction.getTopicArn()));
                        }
                        if (bounceAction.getSmtpReplyCode() != null) {
                            request.addParameter("Rule.Actions.member." + actionsListIndex + ".BounceAction.SmtpReplyCode", StringUtils.fromString((String)bounceAction.getSmtpReplyCode()));
                        }
                        if (bounceAction.getStatusCode() != null) {
                            request.addParameter("Rule.Actions.member." + actionsListIndex + ".BounceAction.StatusCode", StringUtils.fromString((String)bounceAction.getStatusCode()));
                        }
                        if (bounceAction.getMessage() != null) {
                            request.addParameter("Rule.Actions.member." + actionsListIndex + ".BounceAction.Message", StringUtils.fromString((String)bounceAction.getMessage()));
                        }
                        if (bounceAction.getSender() != null) {
                            request.addParameter("Rule.Actions.member." + actionsListIndex + ".BounceAction.Sender", StringUtils.fromString((String)bounceAction.getSender()));
                        }
                    }
                    if ((workmailAction = actionsListValue.getWorkmailAction()) != null) {
                        if (workmailAction.getTopicArn() != null) {
                            request.addParameter("Rule.Actions.member." + actionsListIndex + ".WorkmailAction.TopicArn", StringUtils.fromString((String)workmailAction.getTopicArn()));
                        }
                        if (workmailAction.getOrganizationArn() != null) {
                            request.addParameter("Rule.Actions.member." + actionsListIndex + ".WorkmailAction.OrganizationArn", StringUtils.fromString((String)workmailAction.getOrganizationArn()));
                        }
                    }
                    if ((lambdaAction = actionsListValue.getLambdaAction()) != null) {
                        if (lambdaAction.getTopicArn() != null) {
                            request.addParameter("Rule.Actions.member." + actionsListIndex + ".LambdaAction.TopicArn", StringUtils.fromString((String)lambdaAction.getTopicArn()));
                        }
                        if (lambdaAction.getFunctionArn() != null) {
                            request.addParameter("Rule.Actions.member." + actionsListIndex + ".LambdaAction.FunctionArn", StringUtils.fromString((String)lambdaAction.getFunctionArn()));
                        }
                        if (lambdaAction.getInvocationType() != null) {
                            request.addParameter("Rule.Actions.member." + actionsListIndex + ".LambdaAction.InvocationType", StringUtils.fromString((String)lambdaAction.getInvocationType()));
                        }
                    }
                    if ((stopAction = actionsListValue.getStopAction()) != null) {
                        if (stopAction.getScope() != null) {
                            request.addParameter("Rule.Actions.member." + actionsListIndex + ".StopAction.Scope", StringUtils.fromString((String)stopAction.getScope()));
                        }
                        if (stopAction.getTopicArn() != null) {
                            request.addParameter("Rule.Actions.member." + actionsListIndex + ".StopAction.TopicArn", StringUtils.fromString((String)stopAction.getTopicArn()));
                        }
                    }
                    if ((addHeaderAction = actionsListValue.getAddHeaderAction()) != null) {
                        if (addHeaderAction.getHeaderName() != null) {
                            request.addParameter("Rule.Actions.member." + actionsListIndex + ".AddHeaderAction.HeaderName", StringUtils.fromString((String)addHeaderAction.getHeaderName()));
                        }
                        if (addHeaderAction.getHeaderValue() != null) {
                            request.addParameter("Rule.Actions.member." + actionsListIndex + ".AddHeaderAction.HeaderValue", StringUtils.fromString((String)addHeaderAction.getHeaderValue()));
                        }
                    }
                    if ((sNSAction = actionsListValue.getSNSAction()) != null && sNSAction.getTopicArn() != null) {
                        request.addParameter("Rule.Actions.member." + actionsListIndex + ".SNSAction.TopicArn", StringUtils.fromString((String)sNSAction.getTopicArn()));
                    }
                    ++actionsListIndex;
                }
            }
            if (rule.getScanEnabled() != null) {
                request.addParameter("Rule.ScanEnabled", StringUtils.fromBoolean((Boolean)rule.getScanEnabled()));
            }
        }
        return request;
    }
}

