/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleemail.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.simpleemail.model.CloudWatchDestination;
import com.amazonaws.services.simpleemail.model.CloudWatchDimensionConfiguration;
import com.amazonaws.services.simpleemail.model.CreateConfigurationSetEventDestinationRequest;
import com.amazonaws.services.simpleemail.model.EventDestination;
import com.amazonaws.services.simpleemail.model.KinesisFirehoseDestination;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class CreateConfigurationSetEventDestinationRequestMarshaller
implements Marshaller<Request<CreateConfigurationSetEventDestinationRequest>, CreateConfigurationSetEventDestinationRequest> {
    public Request<CreateConfigurationSetEventDestinationRequest> marshall(CreateConfigurationSetEventDestinationRequest createConfigurationSetEventDestinationRequest) {
        EventDestination eventDestination;
        if (createConfigurationSetEventDestinationRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createConfigurationSetEventDestinationRequest, "AmazonSimpleEmailService");
        request.addParameter("Action", "CreateConfigurationSetEventDestination");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (createConfigurationSetEventDestinationRequest.getConfigurationSetName() != null) {
            request.addParameter("ConfigurationSetName", StringUtils.fromString((String)createConfigurationSetEventDestinationRequest.getConfigurationSetName()));
        }
        if ((eventDestination = createConfigurationSetEventDestinationRequest.getEventDestination()) != null) {
            SdkInternalList dimensionConfigurationsList;
            CloudWatchDestination cloudWatchDestination;
            KinesisFirehoseDestination kinesisFirehoseDestination;
            SdkInternalList matchingEventTypesList;
            if (eventDestination.getName() != null) {
                request.addParameter("EventDestination.Name", StringUtils.fromString((String)eventDestination.getName()));
            }
            if (eventDestination.getEnabled() != null) {
                request.addParameter("EventDestination.Enabled", StringUtils.fromBoolean((Boolean)eventDestination.getEnabled()));
            }
            if (!(matchingEventTypesList = (SdkInternalList)eventDestination.getMatchingEventTypes()).isEmpty() || !matchingEventTypesList.isAutoConstruct()) {
                int matchingEventTypesListIndex = 1;
                for (String matchingEventTypesListValue : matchingEventTypesList) {
                    if (matchingEventTypesListValue != null) {
                        request.addParameter("EventDestination.MatchingEventTypes.member." + matchingEventTypesListIndex, StringUtils.fromString((String)matchingEventTypesListValue));
                    }
                    ++matchingEventTypesListIndex;
                }
            }
            if ((kinesisFirehoseDestination = eventDestination.getKinesisFirehoseDestination()) != null) {
                if (kinesisFirehoseDestination.getIAMRoleARN() != null) {
                    request.addParameter("EventDestination.KinesisFirehoseDestination.IAMRoleARN", StringUtils.fromString((String)kinesisFirehoseDestination.getIAMRoleARN()));
                }
                if (kinesisFirehoseDestination.getDeliveryStreamARN() != null) {
                    request.addParameter("EventDestination.KinesisFirehoseDestination.DeliveryStreamARN", StringUtils.fromString((String)kinesisFirehoseDestination.getDeliveryStreamARN()));
                }
            }
            if (!((cloudWatchDestination = eventDestination.getCloudWatchDestination()) == null || (dimensionConfigurationsList = (SdkInternalList)cloudWatchDestination.getDimensionConfigurations()).isEmpty() && dimensionConfigurationsList.isAutoConstruct())) {
                int dimensionConfigurationsListIndex = 1;
                for (CloudWatchDimensionConfiguration dimensionConfigurationsListValue : dimensionConfigurationsList) {
                    if (dimensionConfigurationsListValue.getDimensionName() != null) {
                        request.addParameter("EventDestination.CloudWatchDestination.DimensionConfigurations.member." + dimensionConfigurationsListIndex + ".DimensionName", StringUtils.fromString((String)dimensionConfigurationsListValue.getDimensionName()));
                    }
                    if (dimensionConfigurationsListValue.getDimensionValueSource() != null) {
                        request.addParameter("EventDestination.CloudWatchDestination.DimensionConfigurations.member." + dimensionConfigurationsListIndex + ".DimensionValueSource", StringUtils.fromString((String)dimensionConfigurationsListValue.getDimensionValueSource()));
                    }
                    if (dimensionConfigurationsListValue.getDefaultDimensionValue() != null) {
                        request.addParameter("EventDestination.CloudWatchDestination.DimensionConfigurations.member." + dimensionConfigurationsListIndex + ".DefaultDimensionValue", StringUtils.fromString((String)dimensionConfigurationsListValue.getDefaultDimensionValue()));
                    }
                    ++dimensionConfigurationsListIndex;
                }
            }
        }
        return request;
    }
}

