/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.annotations.NonNull;
import com.android.resources.ResourceFolderType;
import com.android.tools.lint.checks.TypoDetector;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.ResourceContext;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.Speed;
import com.android.utils.Pair;
import java.io.File;

public class LocaleFolderDetector
extends Detector
implements Detector.ResourceFolderScanner {
    public static final Implementation IMPLEMENTATION = new Implementation(LocaleFolderDetector.class, Scope.RESOURCE_FOLDER_SCOPE);
    public static final Issue ISSUE = Issue.create((String)"LocaleFolder", (String)"Wrong locale name", (String)"Using the new locale name", (String)"From the `java.util.Locale` documentation:\n\"Note that Java uses several deprecated two-letter codes. The Hebrew (\"he\") language code is rewritten as \"iw\", Indonesian (\"id\") as \"in\", and Yiddish (\"yi\") as \"ji\". This rewriting happens even if you construct your own Locale object, not just for instances returned by the various lookup methods.\n\nBecause of this, if you add your localized resources in for example `values-he` they will not be used, since the system will look for `values-iw` instead.\n\nTo work around this, place your resources in a `values` folder using the deprecated language code instead.", (Category)Category.CORRECTNESS, (int)6, (Severity)Severity.WARNING, (Implementation)new Implementation(LocaleFolderDetector.class, Scope.RESOURCE_FOLDER_SCOPE)).addMoreInfo("http://developer.android.com/reference/java/util/Locale.html");

    @NonNull
    public Speed getSpeed() {
        return Speed.FAST;
    }

    public boolean appliesTo(@NonNull ResourceFolderType folderType) {
        return true;
    }

    public void checkFolder(@NonNull ResourceContext context, @NonNull String folderName) {
        String language;
        Pair<String, String> locale = TypoDetector.getLocale(folderName);
        if (locale != null && (language = (String)locale.getFirst()) != null) {
            String replace = null;
            if (language.equals("he")) {
                replace = "iw";
            } else if (language.equals("id")) {
                replace = "in";
            } else if (language.equals("yi")) {
                replace = "ji";
            }
            if (replace != null) {
                String message = String.format("The locale folder \"%1$s\" should be called \"%2$s\" instead; see the java.util.Locale documentation", language, replace);
                context.report(ISSUE, Location.create((File)context.file), message, null);
            }
        }
    }
}

