/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.tools.lint.detector.api.LintUtils;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;

public class PluralsDatabase {
    private static final PluralsDatabase sInstance = new PluralsDatabase();
    private Map<String, EnumSet<Quantity>> mPlurals;
    private Map<Quantity, Map<Set<Quantity>, Boolean>> mMultiValueSetNames = Maps.newEnumMap(Quantity.class);

    @NonNull
    public static PluralsDatabase get() {
        return sInstance;
    }

    @Nullable
    public EnumSet<Quantity> getRelevant(@NonNull String language) {
        this.ensureInitialized();
        return this.mPlurals.get(language);
    }

    public boolean hasMultipleValuesForQuantity(@NonNull String language, @NonNull Quantity quantity) {
        if (quantity == Quantity.one || quantity == Quantity.two || quantity == Quantity.zero) {
            this.ensureInitialized();
            EnumSet<Quantity> relevant = this.mPlurals.get(language);
            if (relevant != null) {
                Map<Set<Quantity>, Boolean> names = this.mMultiValueSetNames.get((Object)quantity);
                assert (names != null) : quantity;
                return names.containsKey(relevant);
            }
        }
        return false;
    }

    private void ensureInitialized() {
        if (this.mPlurals == null) {
            this.initialize();
        }
    }

    private void initialize() {
        EnumSet<Quantity> set22;
        EnumSet<Quantity> empty = EnumSet.noneOf(Quantity.class);
        EnumSet<Quantity> set0 = EnumSet.of(Quantity.few, Quantity.many, Quantity.one, Quantity.two, Quantity.zero);
        EnumSet<Quantity> set1 = EnumSet.of(Quantity.many, Quantity.one, Quantity.two);
        EnumSet<Quantity> set10 = EnumSet.of(Quantity.few, Quantity.many, Quantity.one);
        EnumSet<Quantity> set11 = EnumSet.of(Quantity.few, Quantity.one);
        EnumSet<Quantity> set12 = set10;
        EnumSet<Quantity> set13 = EnumSet.of(Quantity.few, Quantity.one, Quantity.two);
        EnumSet<Quantity> set14 = set10;
        EnumSet<Quantity> set15 = EnumSet.of(Quantity.one);
        EnumSet<Quantity> set16 = set0;
        EnumSet<Quantity> set17 = EnumSet.of(Quantity.one, Quantity.zero);
        EnumSet<Quantity> set18 = set11;
        EnumSet<Quantity> set19 = EnumSet.of(Quantity.few, Quantity.many, Quantity.one, Quantity.two);
        EnumSet<Quantity> set2 = set15;
        EnumSet<Quantity> set20 = set17;
        EnumSet<Quantity> set21 = set15;
        EnumSet<Quantity> set23 = set22 = set13;
        EnumSet<Quantity> set24 = empty;
        EnumSet<Quantity> set25 = set15;
        EnumSet<Quantity> set26 = set15;
        EnumSet<Quantity> set27 = set15;
        EnumSet<Quantity> set28 = set15;
        EnumSet<Quantity> set29 = set15;
        EnumSet<Quantity> set3 = set15;
        EnumSet<Quantity> set30 = set15;
        EnumSet<Quantity> set31 = set15;
        EnumSet<Quantity> set32 = set15;
        EnumSet<Quantity> set33 = set18;
        EnumSet<Quantity> set34 = EnumSet.of(Quantity.many, Quantity.one);
        EnumSet<Quantity> set35 = set10;
        EnumSet<Quantity> set36 = set15;
        EnumSet<Quantity> set37 = set15;
        EnumSet<Quantity> set38 = set15;
        EnumSet<Quantity> set39 = set13;
        EnumSet<Quantity> set4 = set15;
        EnumSet<Quantity> set40 = EnumSet.of(Quantity.many);
        EnumSet<Quantity> set41 = set13;
        EnumSet<Quantity> set42 = set13;
        EnumSet<Quantity> set43 = set19;
        EnumSet<Quantity> set44 = set19;
        EnumSet<Quantity> set45 = set10;
        EnumSet<Quantity> set5 = set17;
        EnumSet<Quantity> set6 = EnumSet.of(Quantity.one, Quantity.two);
        EnumSet<Quantity> set7 = set19;
        EnumSet<Quantity> set8 = set18;
        EnumSet<Quantity> set9 = set18;
        set10 = EnumSet.copyOf(set10);
        set13 = EnumSet.copyOf(set13);
        set15 = EnumSet.copyOf(set15);
        set18 = EnumSet.copyOf(set18);
        set19 = EnumSet.copyOf(set19);
        set21 = EnumSet.copyOf(set21);
        set22 = EnumSet.copyOf(set22);
        set23 = EnumSet.copyOf(set23);
        set25 = EnumSet.copyOf(set25);
        set3 = EnumSet.copyOf(set3);
        set30 = EnumSet.copyOf(set30);
        set31 = EnumSet.copyOf(set31);
        set32 = EnumSet.copyOf(set32);
        set33 = EnumSet.copyOf(set33);
        set34 = EnumSet.copyOf(set34);
        set35 = EnumSet.copyOf(set35);
        set38 = EnumSet.copyOf(set38);
        set39 = EnumSet.copyOf(set39);
        set4 = EnumSet.copyOf(set4);
        set40 = EnumSet.copyOf(set40);
        set42 = EnumSet.copyOf(set42);
        set43 = EnumSet.copyOf(set43);
        set44 = EnumSet.copyOf(set44);
        set45 = EnumSet.copyOf(set45);
        set5 = EnumSet.copyOf(set5);
        set9 = EnumSet.copyOf(set9);
        int INITIAL_CAPACITY = 133;
        this.mPlurals = Maps.newHashMapWithExpectedSize((int)133);
        this.mPlurals.put("af", set2);
        this.mPlurals.put("ak", set3);
        this.mPlurals.put("am", set30);
        this.mPlurals.put("ar", set0);
        this.mPlurals.put("az", set2);
        this.mPlurals.put("be", set10);
        this.mPlurals.put("bg", set2);
        this.mPlurals.put("bh", set3);
        this.mPlurals.put("bm", set24);
        this.mPlurals.put("bn", set30);
        this.mPlurals.put("bo", set24);
        this.mPlurals.put("br", set19);
        this.mPlurals.put("bs", set33);
        this.mPlurals.put("ca", set26);
        this.mPlurals.put("cs", set11);
        this.mPlurals.put("cy", set16);
        this.mPlurals.put("da", set28);
        this.mPlurals.put("de", set26);
        this.mPlurals.put("dv", set2);
        this.mPlurals.put("dz", set24);
        this.mPlurals.put("ee", set2);
        this.mPlurals.put("el", set2);
        this.mPlurals.put("en", set26);
        this.mPlurals.put("eo", set2);
        this.mPlurals.put("es", set2);
        this.mPlurals.put("et", set26);
        this.mPlurals.put("eu", set2);
        this.mPlurals.put("fa", set30);
        this.mPlurals.put("ff", set4);
        this.mPlurals.put("fi", set26);
        this.mPlurals.put("fo", set2);
        this.mPlurals.put("fr", set4);
        this.mPlurals.put("fy", set2);
        this.mPlurals.put("ga", set7);
        this.mPlurals.put("gd", set23);
        this.mPlurals.put("gl", set26);
        this.mPlurals.put("gu", set30);
        this.mPlurals.put("gv", set22);
        this.mPlurals.put("ha", set2);
        this.mPlurals.put("he", set1);
        this.mPlurals.put("hi", set30);
        this.mPlurals.put("hr", set33);
        this.mPlurals.put("hu", set2);
        this.mPlurals.put("hy", set4);
        this.mPlurals.put("id", set24);
        this.mPlurals.put("ig", set24);
        this.mPlurals.put("ii", set24);
        this.mPlurals.put("in", set24);
        this.mPlurals.put("is", set31);
        this.mPlurals.put("it", set26);
        this.mPlurals.put("iu", set6);
        this.mPlurals.put("iw", set1);
        this.mPlurals.put("ja", set24);
        this.mPlurals.put("ji", set26);
        this.mPlurals.put("jv", set24);
        this.mPlurals.put("ka", set2);
        this.mPlurals.put("kk", set2);
        this.mPlurals.put("kl", set2);
        this.mPlurals.put("km", set24);
        this.mPlurals.put("kn", set30);
        this.mPlurals.put("ko", set24);
        this.mPlurals.put("ks", set2);
        this.mPlurals.put("ku", set2);
        this.mPlurals.put("kw", set6);
        this.mPlurals.put("ky", set2);
        this.mPlurals.put("lb", set2);
        this.mPlurals.put("lg", set2);
        this.mPlurals.put("ln", set3);
        this.mPlurals.put("lo", set24);
        this.mPlurals.put("lt", set9);
        this.mPlurals.put("lv", set5);
        this.mPlurals.put("mg", set3);
        this.mPlurals.put("mk", set15);
        this.mPlurals.put("ml", set2);
        this.mPlurals.put("mn", set2);
        this.mPlurals.put("mr", set30);
        this.mPlurals.put("ms", set24);
        this.mPlurals.put("mt", set14);
        this.mPlurals.put("my", set24);
        this.mPlurals.put("nb", set2);
        this.mPlurals.put("nd", set2);
        this.mPlurals.put("ne", set2);
        this.mPlurals.put("nl", set26);
        this.mPlurals.put("nn", set2);
        this.mPlurals.put("no", set2);
        this.mPlurals.put("nr", set2);
        this.mPlurals.put("ny", set2);
        this.mPlurals.put("om", set2);
        this.mPlurals.put("or", set2);
        this.mPlurals.put("os", set2);
        this.mPlurals.put("pa", set3);
        this.mPlurals.put("pl", set12);
        this.mPlurals.put("ps", set2);
        this.mPlurals.put("pt", set27);
        this.mPlurals.put("rm", set2);
        this.mPlurals.put("ro", set8);
        this.mPlurals.put("ru", set34);
        this.mPlurals.put("se", set6);
        this.mPlurals.put("sg", set24);
        this.mPlurals.put("si", set32);
        this.mPlurals.put("sk", set11);
        this.mPlurals.put("sl", set13);
        this.mPlurals.put("sn", set2);
        this.mPlurals.put("so", set2);
        this.mPlurals.put("sq", set2);
        this.mPlurals.put("sr", set33);
        this.mPlurals.put("ss", set2);
        this.mPlurals.put("st", set2);
        this.mPlurals.put("sv", set26);
        this.mPlurals.put("sw", set26);
        this.mPlurals.put("ta", set2);
        this.mPlurals.put("te", set2);
        this.mPlurals.put("th", set24);
        this.mPlurals.put("ti", set3);
        this.mPlurals.put("tk", set2);
        this.mPlurals.put("tl", set25);
        this.mPlurals.put("tn", set2);
        this.mPlurals.put("to", set24);
        this.mPlurals.put("tr", set2);
        this.mPlurals.put("ts", set2);
        this.mPlurals.put("uk", set35);
        this.mPlurals.put("ur", set26);
        this.mPlurals.put("uz", set2);
        this.mPlurals.put("ve", set2);
        this.mPlurals.put("vi", set24);
        this.mPlurals.put("vo", set2);
        this.mPlurals.put("wa", set3);
        this.mPlurals.put("wo", set24);
        this.mPlurals.put("xh", set2);
        this.mPlurals.put("yi", set26);
        this.mPlurals.put("yo", set24);
        this.mPlurals.put("zh", set24);
        this.mPlurals.put("zu", set30);
        assert (this.mPlurals.size() == 133) : this.mPlurals.size();
        this.mMultiValueSetNames.put(Quantity.one, PluralsDatabase.newIdentityHashMap(set10, set13, set15, set18, set19, set21, set22, set23, set25, set3, set30, set31, set32, set33, set34, set35, set38, set39, set4, set40, set42, set45, set5, set9));
        this.mMultiValueSetNames.put(Quantity.two, PluralsDatabase.newIdentityHashMap(set13, set19, set22, set23, set40, set43, set44, set45));
        this.mMultiValueSetNames.put(Quantity.zero, PluralsDatabase.newIdentityHashMap(set5));
    }

    private static Map<Set<Quantity>, Boolean> newIdentityHashMap(Set<Quantity> ... elements) {
        IdentityHashMap map = Maps.newIdentityHashMap();
        for (Set<Quantity> set : elements) {
            map.put(set, true);
        }
        return map;
    }

    @Nullable
    public String findIntegerExamples(@NonNull String language, @NonNull Quantity quantity) {
        return null;
    }

    public static enum Quantity {
        few,
        many,
        one,
        two,
        zero,
        other;


        @Nullable
        public static Quantity get(@NonNull String name) {
            for (Quantity quantity : Quantity.values()) {
                if (!name.equals(quantity.name())) continue;
                return quantity;
            }
            return null;
        }

        public static String formatSet(EnumSet<Quantity> set) {
            ArrayList<String> list = new ArrayList<String>(set.size());
            for (Quantity quantity : set) {
                list.add(quantity.name());
            }
            return LintUtils.formatList(list, (int)Integer.MAX_VALUE);
        }
    }
}

