/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.annotations.NonNull;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LintUtils;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.Speed;
import com.google.common.base.Charsets;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.EnumSet;

public class PrivateKeyDetector
extends Detector
implements Detector.OtherFileScanner {
    public static final Issue ISSUE = Issue.create((String)"PackagedPrivateKey", (String)"Packaged private key", (String)"Looks for packaged private key files", (String)"In general, you should not package private key files inside your app.", (Category)Category.SECURITY, (int)8, (Severity)Severity.FATAL, (Implementation)new Implementation(PrivateKeyDetector.class, Scope.OTHER_SCOPE));

    private static boolean isPrivateKeyFile(File file) {
        if (!file.isFile() || !LintUtils.endsWith((String)file.getPath(), (String)"pem") && !LintUtils.endsWith((String)file.getPath(), (String)"key")) {
            return false;
        }
        try {
            String firstLine = Files.readFirstLine((File)file, (Charset)Charsets.US_ASCII);
            return firstLine != null && firstLine.startsWith("---") && firstLine.contains("PRIVATE KEY");
        }
        catch (IOException iOException) {
            return false;
        }
    }

    @NonNull
    public EnumSet<Scope> getApplicableFiles() {
        return Scope.OTHER_SCOPE;
    }

    public void run(@NonNull Context context) {
        if (!context.getProject().getReportIssues()) {
            return;
        }
        File file = context.file;
        if (PrivateKeyDetector.isPrivateKeyFile(file)) {
            String fileName = file.getParentFile().getName() + File.separator + file.getName();
            String message = String.format("The %1$s file seems to be a private key file. Please make sure not to embed this in your APK file.", fileName);
            context.report(ISSUE, Location.create((File)file), message, null);
        }
    }

    @NonNull
    public Speed getSpeed() {
        return Speed.NORMAL;
    }
}

