/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.codegen;

import com.atlassian.bamboo.specs.api.codegen.CodeEmitter;
import com.atlassian.bamboo.specs.api.codegen.CodeGenerationContext;
import com.atlassian.bamboo.specs.api.codegen.CodeGenerationException;
import com.atlassian.bamboo.specs.api.model.EntityProperties;
import com.atlassian.bamboo.specs.api.validators.common.ImporterUtils;
import com.atlassian.bamboo.specs.codegen.emitters.BuilderClassProvider;
import com.atlassian.bamboo.specs.codegen.emitters.ValueEmitterFactory;
import com.atlassian.bamboo.specs.util.BambooSpecProperties;
import com.atlassian.bamboo.specs.util.BambooSpecSerializer;
import com.atlassian.bamboo.specs.util.Yamlizator;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;

public class Javaizator {
    private final EntityProperties entity;
    private final CodeGenerationContext context = new CodeGenerationContext();

    public Javaizator(EntityProperties entity) {
        ImporterUtils.checkNotNull((String)"entity", (Object)entity);
        this.entity = entity;
    }

    private String buildCode(String rootEntityValue) throws CodeGenerationException {
        StringBuilder builder = new StringBuilder();
        builder.append("public class HllSample {");
        this.context.incIndentation();
        builder.append(this.context.newLine());
        builder.append("public static void main(String... argv) {");
        this.context.incIndentation();
        builder.append(this.context.newLine());
        builder.append(this.context.importClassName(BuilderClassProvider.findBuilderClass(this.entity.getClass())));
        builder.append(" rootObject = ");
        builder.append(rootEntityValue);
        builder.append(";");
        builder.append(this.context.newLine());
        builder.append(this.context.newLine());
        builder.append("System.out.print(").append(this.context.importClassName(BambooSpecSerializer.class)).append(".dump(rootObject));");
        this.context.decIndentation();
        builder.append(this.context.newLine());
        builder.append("}");
        this.context.decIndentation();
        builder.append(this.context.newLine());
        builder.append("}");
        return builder.toString();
    }

    public String emitCode() throws CodeGenerationException {
        CodeEmitter topLevelEntity = ValueEmitterFactory.emitterFor(this.entity);
        this.context.incIndentation();
        this.context.incIndentation();
        this.context.incIndentation();
        String rootEntityValue = topLevelEntity.emitCode(this.context, (Object)this.entity);
        this.context.decIndentation();
        this.context.decIndentation();
        this.context.decIndentation();
        String main = this.buildCode(rootEntityValue);
        StringBuilder codeBuilder = new StringBuilder();
        for (String anImport : this.context.getImports()) {
            codeBuilder.append("import ").append(anImport).append(";\n");
        }
        codeBuilder.append("\n");
        codeBuilder.append(main);
        return codeBuilder.toString();
    }

    public static void main(String ... argv) {
        if (argv.length < 1) {
            System.out.println("File argument missing");
            return;
        }
        String filePath = argv[0];
        try {
            BambooSpecProperties o = (BambooSpecProperties)Yamlizator.getYaml().load((InputStream)new FileInputStream(new File(filePath)));
            String javaCode = new Javaizator(o.getRootEntity()).emitCode();
            System.out.print(javaCode);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

