/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.builders.repository.bitbucket.server;

import com.atlassian.bamboo.specs.api.builders.EntityPropertiesBuilder;
import com.atlassian.bamboo.specs.api.builders.applink.ApplicationLink;
import com.atlassian.bamboo.specs.api.builders.repository.VcsChangeDetection;
import com.atlassian.bamboo.specs.api.builders.repository.VcsRepository;
import com.atlassian.bamboo.specs.api.model.applink.ApplicationLinkProperties;
import com.atlassian.bamboo.specs.api.model.repository.VcsChangeDetectionProperties;
import com.atlassian.bamboo.specs.api.util.EntityPropertiesBuilders;
import com.atlassian.bamboo.specs.api.validators.common.ImporterUtils;
import com.atlassian.bamboo.specs.builders.repository.bitbucket.server.BitbucketServerMirror;
import com.atlassian.bamboo.specs.model.repository.bitbucket.server.BitbucketServerMirrorProperties;
import com.atlassian.bamboo.specs.model.repository.bitbucket.server.BitbucketServerRepositoryProperties;
import java.time.Duration;
import org.jetbrains.annotations.NotNull;

public class BitbucketServerRepository
extends VcsRepository<BitbucketServerRepository, BitbucketServerRepositoryProperties> {
    private ApplicationLinkProperties server;
    private String projectKey;
    private String repositorySlug;
    private String sshPublicKey;
    private String sshPrivateKey;
    private String branch;
    private boolean useShallowClones;
    private boolean useRemoteAgentCache = true;
    private boolean useSubmodules;
    private Duration commandTimeout = Duration.ofMinutes(180L);
    private boolean verboseLogs;
    private boolean fetchWholeRepository;
    private boolean useLfs;
    private BitbucketServerMirrorProperties mirror;
    private VcsChangeDetectionProperties vcsChangeDetection;

    public BitbucketServerRepository server(@NotNull ApplicationLink server) {
        ImporterUtils.checkNotNull((String)"server", (Object)server);
        this.server = (ApplicationLinkProperties)EntityPropertiesBuilders.build((EntityPropertiesBuilder)server);
        return this;
    }

    public BitbucketServerRepository projectKey(@NotNull String projectKey) {
        ImporterUtils.checkNotBlank((String)"projectKey", (String)projectKey);
        this.projectKey = projectKey;
        return this;
    }

    public BitbucketServerRepository repositorySlug(@NotNull String repositorySlug) {
        ImporterUtils.checkNotBlank((String)"repositorySlug", (String)repositorySlug);
        this.repositorySlug = repositorySlug;
        return this;
    }

    public BitbucketServerRepository sshPublicKey(@NotNull String sshPublicKey) {
        ImporterUtils.checkNotBlank((String)"sshPublicKey", (String)sshPublicKey);
        this.sshPublicKey = sshPublicKey;
        return this;
    }

    public BitbucketServerRepository sshPrivateKey(@NotNull String sshPrivateKey) {
        ImporterUtils.checkNotBlank((String)"sshPrivateKey", (String)sshPrivateKey);
        this.sshPrivateKey = sshPrivateKey;
        return this;
    }

    public BitbucketServerRepository branch(@NotNull String branch) {
        ImporterUtils.checkNotNull((String)"branch", (Object)branch);
        this.branch = branch;
        return this;
    }

    public BitbucketServerRepository shallowClonesEnabled(boolean useShallowClones) {
        this.useShallowClones = useShallowClones;
        return this;
    }

    public BitbucketServerRepository submodulesEnabled(boolean useSubmodules) {
        this.useSubmodules = useSubmodules;
        return this;
    }

    public BitbucketServerRepository remoteAgentCacheEnabled(boolean useRemoteAgentCache) {
        this.useRemoteAgentCache = useRemoteAgentCache;
        return this;
    }

    public BitbucketServerRepository commandTimeout(Duration commandTimeout) {
        this.commandTimeout = commandTimeout;
        return this;
    }

    public BitbucketServerRepository commandTimeoutInMinutes(int commandTimeoutMinutes) {
        return this.commandTimeout(Duration.ofMinutes(commandTimeoutMinutes));
    }

    public BitbucketServerRepository verboseLogs(boolean verboseLogs) {
        this.verboseLogs = verboseLogs;
        return this;
    }

    public BitbucketServerRepository fetchWholeRepository(boolean fetchWholeRepository) {
        this.fetchWholeRepository = fetchWholeRepository;
        return this;
    }

    public BitbucketServerRepository lfsEnabled(boolean useLfs) {
        this.useLfs = useLfs;
        return this;
    }

    public BitbucketServerRepository defaultChangeDetection() {
        this.vcsChangeDetection = null;
        return this;
    }

    public BitbucketServerRepository changeDetection(@NotNull VcsChangeDetection vcsChangeDetection) {
        ImporterUtils.checkNotNull((String)"vcsChangeDetection", (Object)vcsChangeDetection);
        this.vcsChangeDetection = (VcsChangeDetectionProperties)EntityPropertiesBuilders.build((EntityPropertiesBuilder)vcsChangeDetection);
        return this;
    }

    public BitbucketServerRepository mirror(@NotNull BitbucketServerMirror mirror) {
        ImporterUtils.checkNotNull((String)"mirror", (Object)((Object)mirror));
        this.mirror = (BitbucketServerMirrorProperties)EntityPropertiesBuilders.build((EntityPropertiesBuilder)mirror);
        return this;
    }

    protected BitbucketServerRepositoryProperties build() {
        return new BitbucketServerRepositoryProperties(this.name, this.oid, this.description, this.parent, this.repositoryViewer, this.server, this.projectKey, this.repositorySlug, this.sshPublicKey, this.sshPrivateKey, this.branch, this.vcsChangeDetection, this.useShallowClones, this.useRemoteAgentCache, this.useSubmodules, this.commandTimeout, this.verboseLogs, this.fetchWholeRepository, this.useLfs, this.mirror);
    }
}

