/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.builders.task;

import com.atlassian.bamboo.specs.api.builders.task.Task;
import com.atlassian.bamboo.specs.api.validators.common.ImporterUtils;
import com.atlassian.bamboo.specs.model.task.TestParserTaskProperties;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TestParserTask
extends Task<TestParserTask, TestParserTaskProperties> {
    private final TestParserTaskProperties.TestType testType;
    private Set<String> resultDirectories = new LinkedHashSet<String>();
    @Nullable
    private Boolean pickUpTestResultsCreatedOutsideOfThisBuild;

    public TestParserTask(TestParserTaskProperties.TestType testType) {
        this.testType = testType;
    }

    public static TestParserTask createJUnitParserTask() {
        return new TestParserTask(TestParserTaskProperties.TestType.JUNIT);
    }

    public static TestParserTask createTestNGParserTask() {
        return new TestParserTask(TestParserTaskProperties.TestType.TESTNG);
    }

    public static TestParserTask createNUnitParserTask() {
        return new TestParserTask(TestParserTaskProperties.TestType.NUNIT);
    }

    public TestParserTaskProperties.TestType getTestType() {
        return this.testType;
    }

    public TestParserTask resultDirectories(String ... resultDirectories) {
        ImporterUtils.checkNotNull((String)"resultDirectories", (Object)resultDirectories);
        Arrays.stream(resultDirectories).forEach(dir -> {
            String cfr_ignored_0 = (String)ImporterUtils.checkNotNull((String)"resultDirectories", (Object)dir);
        });
        Arrays.stream(resultDirectories).forEach(this.resultDirectories::add);
        return this;
    }

    public TestParserTask defaultResultDirectory() {
        switch (this.testType) {
            case JUNIT: {
                return this.resultDirectories("**/test-reports/*.xml");
            }
            case NUNIT: {
                return this.resultDirectories("**/test-reports/*.xml");
            }
            case TESTNG: {
                return this.resultDirectories("**/testng-results.xml");
            }
        }
        throw new IllegalStateException("Unsupported test type: " + (Object)((Object)this.testType));
    }

    public TestParserTask pickUpTestResultsCreatedOutsideOfThisBuild(@Nullable Boolean pickUpTestResultsCreatedOutsideOfThisBuild) {
        this.pickUpTestResultsCreatedOutsideOfThisBuild = pickUpTestResultsCreatedOutsideOfThisBuild;
        return this;
    }

    @NotNull
    protected TestParserTaskProperties build() {
        return new TestParserTaskProperties(this.testType, this.description, this.taskEnabled, this.resultDirectories, this.pickUpTestResultsCreatedOutsideOfThisBuild);
    }
}

