/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.codegen.emitters.task;

import com.atlassian.bamboo.specs.api.codegen.CodeGenerationContext;
import com.atlassian.bamboo.specs.api.codegen.CodeGenerationException;
import com.atlassian.bamboo.specs.api.model.EntityProperties;
import com.atlassian.bamboo.specs.builders.task.ScpTask;
import com.atlassian.bamboo.specs.codegen.emitters.task.ArtifactItemEmitter;
import com.atlassian.bamboo.specs.codegen.emitters.value.EntityPropertiesEmitter;
import com.atlassian.bamboo.specs.model.task.ArtifactItemProperties;
import com.atlassian.bamboo.specs.model.task.ScpTaskProperties;
import org.jetbrains.annotations.NotNull;

public class ScpTaskEmitter
extends EntityPropertiesEmitter<ScpTaskProperties> {
    @Override
    @NotNull
    public String emitCode(@NotNull CodeGenerationContext context, @NotNull ScpTaskProperties entity) throws CodeGenerationException {
        this.builderClass = ScpTask.class;
        this.fieldsToSkip.add("artifactItem");
        this.fieldsToSkip.add("localPath");
        this.fieldsToSkip.add("localPathAntStyle");
        this.fieldsToSkip.add("password");
        this.fieldsToSkip.add("key");
        this.fieldsToSkip.add("passphrase");
        return this.emitConstructorInvocation(context, entity) + this.emitFields(context, (EntityProperties)entity) + context.incIndentation() + context.newLine() + this.emitCodeForAuthentication(context, entity) + context.newLine() + this.emitCodeForLocalPathOrArtifact(context, entity) + context.decIndentation();
    }

    private String emitCodeForAuthentication(@NotNull CodeGenerationContext context, @NotNull ScpTaskProperties entity) {
        switch (entity.getAuthenticationType()) {
            case PASSWORD: {
                return String.format(".authenticateWithPassword(%s)", "/* PUT YOUR SENSITIVE INFORMATION HERE*/");
            }
            case KEY_WITHOUT_PASSPHRASE: {
                return String.format(".authenticateWithKey(%s)", "/* PUT YOUR SENSITIVE INFORMATION HERE*/");
            }
            case KEY_WITH_PASSPHRASE: {
                return String.format(".authenticateWithKeyWithPassphrase(%s, %s)", "/* PUT YOUR SENSITIVE INFORMATION HERE*/", "/* PUT YOUR SENSITIVE INFORMATION HERE*/");
            }
        }
        return "";
    }

    private String emitCodeForLocalPathOrArtifact(@NotNull CodeGenerationContext context, @NotNull ScpTaskProperties entity) throws CodeGenerationException {
        if (entity.getLocalPath() != null) {
            return this.emitCodeForLocalPath(entity);
        }
        if (entity.getArtifactItem() != null) {
            return this.emitCodeForArtifact(context, entity);
        }
        throw new CodeGenerationException("ScpTask requires an artifact to be uploaded. Neither a local file/directory nor a downloaded artifact was found in the task configuration.");
    }

    private String emitCodeForLocalPath(@NotNull ScpTaskProperties entity) {
        return String.format(".fromLocalPath(\"%s\", %b)", entity.getLocalPath(), entity.isLocalPathAntStyle());
    }

    private String emitCodeForArtifact(@NotNull CodeGenerationContext context, @NotNull ScpTaskProperties entity) throws CodeGenerationException {
        ArtifactItemProperties aip = entity.getArtifactItem();
        if (aip == null) {
            throw new CodeGenerationException("Artifact property is null");
        }
        return String.format(".fromArtifact(%s)", new ArtifactItemEmitter().emitCode(context, aip));
    }
}

