/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.model.task;

import com.atlassian.bamboo.specs.api.codegen.annotations.CodeGenerator;
import com.atlassian.bamboo.specs.api.exceptions.PropertiesValidationException;
import com.atlassian.bamboo.specs.api.model.AtlassianModuleProperties;
import com.atlassian.bamboo.specs.api.validators.common.ImporterUtils;
import com.atlassian.bamboo.specs.api.validators.common.ValidationContext;
import com.atlassian.bamboo.specs.codegen.emitters.task.ScpTaskEmitter;
import com.atlassian.bamboo.specs.model.task.ArtifactItemProperties;
import com.atlassian.bamboo.specs.model.task.BaseSshTaskProperties;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@CodeGenerator(value=ScpTaskEmitter.class)
@Immutable
public class ScpTaskProperties
extends BaseSshTaskProperties {
    private static final AtlassianModuleProperties ATLASSIAN_PLUGIN = new AtlassianModuleProperties("com.atlassian.bamboo.plugins.bamboo-scp-plugin:scptask");
    @Nullable
    private ArtifactItemProperties artifactItem;
    @Nullable
    private String localPath;
    private boolean localPathAntStyle = false;
    private String remotePath;

    private ScpTaskProperties() {
        this.artifactItem = null;
        this.localPath = null;
        this.remotePath = null;
    }

    public ScpTaskProperties(String description, boolean enabled, String host, String username, BaseSshTaskProperties.AuthenticationType authenticationType, @Nullable String password, @Nullable String key, @Nullable String passphrase, @Nullable String hostFingerprint, int port, @Nullable ArtifactItemProperties artifactItem, @Nullable String localPath, boolean localPathAntStyle, String remotePath) throws PropertiesValidationException {
        super(description, enabled, host, username, authenticationType, password, key, passphrase, hostFingerprint, port);
        this.artifactItem = artifactItem;
        this.localPath = localPath;
        this.localPathAntStyle = localPathAntStyle;
        this.remotePath = remotePath;
        this.validate();
    }

    @NotNull
    public AtlassianModuleProperties getAtlassianPlugin() {
        return ATLASSIAN_PLUGIN;
    }

    @Deprecated
    @Nullable
    public String getArtifactName() {
        return null;
    }

    @Nullable
    public ArtifactItemProperties getArtifactItem() {
        return this.artifactItem;
    }

    @Nullable
    public String getLocalPath() {
        return this.localPath;
    }

    public boolean isLocalPathAntStyle() {
        return this.localPathAntStyle;
    }

    public String getRemotePath() {
        return this.remotePath;
    }

    @Override
    public void validate() throws PropertiesValidationException {
        super.validate();
        ValidationContext context = ValidationContext.of((String)"SCP task");
        ImporterUtils.checkArgument((ValidationContext)context.with("artifact name or local path"), (this.artifactItem != null || !StringUtils.isBlank((CharSequence)this.localPath) ? 1 : 0) != 0, (Object)"artifact name or local path must be set");
        ImporterUtils.checkRequired((ValidationContext)context.with("remote path"), (Object)this.remotePath);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ScpTaskProperties that = (ScpTaskProperties)((Object)o);
        return this.localPathAntStyle == that.localPathAntStyle && Objects.equals(this.artifactItem, that.artifactItem) && Objects.equals(this.localPath, that.localPath) && Objects.equals(this.remotePath, that.remotePath);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.artifactItem, this.localPath, this.localPathAntStyle, this.remotePath);
    }
}

