/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.codegen;

import com.atlassian.bamboo.specs.api.BambooSpec;
import com.atlassian.bamboo.specs.api.codegen.CodeEmitter;
import com.atlassian.bamboo.specs.api.codegen.CodeGenerationContext;
import com.atlassian.bamboo.specs.api.codegen.CodeGenerationException;
import com.atlassian.bamboo.specs.api.exceptions.PropertiesValidationException;
import com.atlassian.bamboo.specs.api.model.EntityProperties;
import com.atlassian.bamboo.specs.api.validators.common.ImporterUtils;
import com.atlassian.bamboo.specs.codegen.BuilderClassProvider;
import com.atlassian.bamboo.specs.codegen.emitters.value.ValueEmitterFactory;
import com.atlassian.bamboo.specs.util.BambooServer;
import com.atlassian.bamboo.specs.util.BambooSpecProperties;
import com.atlassian.bamboo.specs.util.Yamlizator;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;
import org.jetbrains.annotations.NotNull;

public class BambooSpecsGenerator {
    private final Map<String, EntityProperties> entityByName = new LinkedHashMap<String, EntityProperties>();
    private final CodeGenerationContext context = new CodeGenerationContext();

    public BambooSpecsGenerator() {
    }

    public BambooSpecsGenerator(EntityProperties entityProperties) throws PropertiesValidationException {
        this();
        this.addEntity("rootObject", entityProperties);
    }

    public BambooSpecsGenerator addEntity(String entityName, EntityProperties entityProperties) throws PropertiesValidationException {
        ImporterUtils.checkNotNull((String)"entity name", (Object)entityName);
        ImporterUtils.checkNotNull((String)"entity", (Object)entityProperties);
        if (this.entityByName.putIfAbsent(entityName, entityProperties) != null) {
            throw new PropertiesValidationException(String.format("Entity with name %s already defined.", entityName));
        }
        return this;
    }

    private String buildCode(String url) throws CodeGenerationException {
        StringBuilder builder = new StringBuilder();
        this.context.importClassName(BambooSpec.class);
        builder.append("@BambooSpec");
        builder.append(this.context.newLine());
        builder.append("public class PlanSpec {");
        this.context.incIndentation();
        builder.append(this.context.newLine());
        builder.append("public static void main(String... argv) {");
        this.context.incIndentation();
        builder.append(this.context.newLine());
        builder.append("//By default credentials are read from the '.credentials' file.").append(this.context.newLine());
        builder.append(this.context.importClassName(BambooServer.class)).append(" bambooServer = new BambooServer(\"").append(url).append("\");");
        for (String entityName : this.entityByName.keySet()) {
            builder.append(this.context.newLine()).append(this.context.newLine());
            this.insertCode(builder, entityName, this.entityByName.get(entityName));
        }
        this.context.decIndentation();
        builder.append(this.context.newLine());
        builder.append("}");
        this.context.decIndentation();
        builder.append(this.context.newLine());
        builder.append("}");
        return builder.toString();
    }

    private void insertCode(StringBuilder builder, String entityName, EntityProperties entity) throws CodeGenerationException {
        if (entity instanceof Comment) {
            Comment comment = (Comment)entity;
            if (comment.newLineBefore) {
                builder.append(this.context.newLine());
            }
            builder.append("// ").append(comment.comment);
            if (comment.newLineAfter) {
                builder.append(this.context.newLine());
            }
        } else {
            CodeEmitter codeEmitter = ValueEmitterFactory.emitterFor(entity);
            String entityCodeRightSide = codeEmitter.emitCode(this.context, (Object)entity);
            builder.append(this.context.importClassName(BuilderClassProvider.findBuilderClass(entity.getClass())));
            builder.append(String.format(" %s = %s;", entityName, entityCodeRightSide));
            builder.append(this.context.newLine());
            builder.append(this.context.newLine());
            builder.append(String.format("bambooServer.publish(%s);", entityName));
        }
    }

    public String emitCode() throws CodeGenerationException {
        return this.emitCode("http://localhost:8085");
    }

    public String emitCode(@NotNull String bambooServerUrl) throws CodeGenerationException {
        String main = this.buildCode(bambooServerUrl);
        StringBuilder codeBuilder = new StringBuilder();
        for (String anImport : this.context.getImports()) {
            codeBuilder.append("import ").append(anImport).append(";\n");
        }
        codeBuilder.append("\n");
        codeBuilder.append(main);
        return codeBuilder.toString();
    }

    public static void main(String ... argv) {
        if (argv.length < 1) {
            System.out.println("File argument missing");
            return;
        }
        String filePath = argv[0];
        try {
            BambooSpecProperties o = (BambooSpecProperties)Yamlizator.getYaml().load((InputStream)new FileInputStream(new File(filePath)));
            String javaCode = new BambooSpecsGenerator(o.getRootEntity()).emitCode();
            System.out.print(javaCode);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Immutable
    public static class Comment
    implements EntityProperties {
        private String comment;
        private boolean newLineBefore;
        private boolean newLineAfter;

        private Comment() {
        }

        public Comment(String comment) {
            this(comment, true, true);
        }

        public Comment(String comment, boolean newLineBefore, boolean newLineAfter) {
            this.comment = comment;
            this.newLineBefore = newLineBefore;
            this.newLineAfter = newLineAfter;
        }

        public String toString() {
            return this.comment;
        }

        public void validate() {
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Comment comment1 = (Comment)o;
            return this.newLineBefore == comment1.newLineBefore && this.newLineAfter == comment1.newLineAfter && Objects.equals(this.comment, comment1.comment);
        }

        public int hashCode() {
            return Objects.hash(this.comment, this.newLineBefore, this.newLineAfter);
        }
    }
}

