/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.codegen.emitters.value;

import com.atlassian.bamboo.specs.api.codegen.CodeEmitter;
import com.atlassian.bamboo.specs.api.codegen.CodeGenerationContext;
import com.atlassian.bamboo.specs.api.codegen.CodeGenerationException;
import com.atlassian.bamboo.specs.codegen.emitters.value.ValueEmitterFactory;
import com.atlassian.bamboo.specs.util.MapBuilder;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class MapEmitter
implements CodeEmitter<Map> {
    @NotNull
    public String emitCode(@NotNull CodeGenerationContext context, @NotNull Map value) throws CodeGenerationException {
        StringBuilder builder = new StringBuilder();
        Map map = value;
        if (map.isEmpty()) {
            return context.importClassName(Collections.class) + ".emptyMap()";
        }
        builder.append("new ").append(context.importClassName(MapBuilder.class)).append("()");
        context.incIndentation();
        Set entrySet = map.entrySet();
        for (Map.Entry entry : entrySet) {
            StringBuilder itemBuilder = new StringBuilder();
            try {
                itemBuilder.append(context.newLine());
                itemBuilder.append(".put(");
                CodeEmitter codeEmitter = ValueEmitterFactory.emitterFor(entry.getKey());
                itemBuilder.append(codeEmitter.emitCode(context, entry.getKey()));
                itemBuilder.append(", ");
                CodeEmitter codeEmitter2 = ValueEmitterFactory.emitterFor(entry.getValue());
                itemBuilder.append(codeEmitter2.emitCode(context, entry.getValue()));
                itemBuilder.append(")");
                builder.append(itemBuilder.toString());
            }
            catch (CodeGenerationException e) {
                builder.append(context.newLine());
                builder.append("//Could not generate map item with key: " + entry.getKey().toString());
            }
        }
        builder.append(context.newLine());
        builder.append(".build()");
        context.decIndentation();
        return builder.toString();
    }
}

