/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.model.task;

import com.atlassian.bamboo.specs.api.exceptions.PropertiesValidationException;
import com.atlassian.bamboo.specs.api.model.AtlassianModuleProperties;
import com.atlassian.bamboo.specs.api.model.task.TaskProperties;
import com.atlassian.bamboo.specs.api.validators.common.ImporterUtils;
import com.atlassian.bamboo.specs.api.validators.common.ValidationContext;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Immutable
public final class CommandTaskProperties
extends TaskProperties {
    private static final AtlassianModuleProperties ATLASSIAN_PLUGIN = new AtlassianModuleProperties("com.atlassian.bamboo.plugins.scripttask:task.builder.command");
    private final String executable;
    @Nullable
    private final String argument;
    @Nullable
    private final String environmentVariables;
    @Nullable
    private final String workingSubdirectory;

    private CommandTaskProperties() {
        this.executable = null;
        this.argument = null;
        this.environmentVariables = null;
        this.workingSubdirectory = null;
    }

    public CommandTaskProperties(String description, boolean enabled, @NotNull String executable, @Nullable String argument, @Nullable String environmentVariables, @Nullable String workingSubdirectory) throws PropertiesValidationException {
        super(description, enabled);
        this.executable = executable;
        this.argument = argument;
        this.environmentVariables = environmentVariables;
        this.workingSubdirectory = workingSubdirectory;
        this.validate();
    }

    @NotNull
    public AtlassianModuleProperties getAtlassianPlugin() {
        return ATLASSIAN_PLUGIN;
    }

    @NotNull
    public String getExecutable() {
        return this.executable;
    }

    @Nullable
    public String getArgument() {
        return this.argument;
    }

    @Nullable
    public String getEnvironmentVariables() {
        return this.environmentVariables;
    }

    @Nullable
    public String getWorkingSubdirectory() {
        return this.workingSubdirectory;
    }

    public void validate() throws PropertiesValidationException {
        super.validate();
        ValidationContext context = ValidationContext.of((String)"Command task");
        ImporterUtils.checkThat((ValidationContext)context, (boolean)StringUtils.isNotBlank((CharSequence)this.executable), (String)"Executable is not defined", (Object[])new Object[0]);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CommandTaskProperties that = (CommandTaskProperties)((Object)o);
        return Objects.equals(this.getExecutable(), that.getExecutable()) && Objects.equals(this.getArgument(), that.getArgument()) && Objects.equals(this.getEnvironmentVariables(), that.getEnvironmentVariables()) && Objects.equals(this.getWorkingSubdirectory(), that.getWorkingSubdirectory());
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getExecutable(), this.getArgument(), this.getEnvironmentVariables(), this.getWorkingSubdirectory());
    }
}

