/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.model.task;

import com.atlassian.bamboo.specs.api.codegen.annotations.CodeGenerator;
import com.atlassian.bamboo.specs.api.exceptions.PropertiesValidationException;
import com.atlassian.bamboo.specs.api.model.AtlassianModuleProperties;
import com.atlassian.bamboo.specs.api.model.credentials.SharedCredentialsIdentifierProperties;
import com.atlassian.bamboo.specs.api.util.InliningUtils;
import com.atlassian.bamboo.specs.api.validators.common.ImporterUtils;
import com.atlassian.bamboo.specs.api.validators.common.ValidationContext;
import com.atlassian.bamboo.specs.codegen.emitters.task.SshTaskEmitter;
import com.atlassian.bamboo.specs.model.task.BaseSshTaskProperties;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@CodeGenerator(value=SshTaskEmitter.class)
@Immutable
public class SshTaskProperties
extends BaseSshTaskProperties {
    private static final AtlassianModuleProperties ATLASSIAN_PLUGIN = new AtlassianModuleProperties("com.atlassian.bamboo.plugins.bamboo-scp-plugin:sshtask");
    public static final int DEFAULT_KEEP_ALIVE_INTERVAL = InliningUtils.preventInlining((int)0);
    private final String command;
    private final int keepAliveIntervalInSec;

    private SshTaskProperties() {
        this.command = null;
        this.keepAliveIntervalInSec = DEFAULT_KEEP_ALIVE_INTERVAL;
    }

    public SshTaskProperties(String description, boolean enabled, String host, String username, BaseSshTaskProperties.AuthenticationType authenticationType, @Nullable String password, @Nullable String key, @Nullable String passphrase, @Nullable SharedCredentialsIdentifierProperties sharedCredentialsIdentifier, @Nullable String hostFingerprint, int port, int keepAliveIntervalInSec, String command) throws PropertiesValidationException {
        super(description, enabled, host, username, authenticationType, password, key, passphrase, sharedCredentialsIdentifier, hostFingerprint, port);
        this.command = command;
        this.keepAliveIntervalInSec = keepAliveIntervalInSec;
        this.validate();
    }

    @NotNull
    public AtlassianModuleProperties getAtlassianPlugin() {
        return ATLASSIAN_PLUGIN;
    }

    public String getCommand() {
        return this.command;
    }

    public int getKeepAliveIntervalInSec() {
        return this.keepAliveIntervalInSec;
    }

    @Override
    public void validate() throws PropertiesValidationException {
        super.validate();
        ValidationContext context = ValidationContext.of((String)"SSH task");
        ImporterUtils.checkRequired((ValidationContext)context, (String)"command", (Object)this.command);
        ImporterUtils.checkNotNegative((ValidationContext)context, (String)"keepAliveIntervalInSec", (int)this.keepAliveIntervalInSec);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SshTaskProperties that = (SshTaskProperties)((Object)o);
        return Objects.equals(this.command, that.command) && this.keepAliveIntervalInSec == that.keepAliveIntervalInSec;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.command, this.keepAliveIntervalInSec);
    }
}

