/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.builders.task;

import com.atlassian.bamboo.specs.api.builders.EntityPropertiesBuilder;
import com.atlassian.bamboo.specs.api.builders.plan.PlanIdentifier;
import com.atlassian.bamboo.specs.api.builders.plan.artifact.Artifact;
import com.atlassian.bamboo.specs.api.util.EntityPropertiesBuilders;
import com.atlassian.bamboo.specs.api.validators.common.ImporterUtils;
import com.atlassian.bamboo.specs.api.validators.common.ValidationContext;
import com.atlassian.bamboo.specs.builders.task.ArtifactItem;
import com.atlassian.bamboo.specs.builders.task.BaseSshTask;
import com.atlassian.bamboo.specs.model.task.ArtifactItemProperties;
import com.atlassian.bamboo.specs.model.task.ScpTaskProperties;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class ScpTask
extends BaseSshTask<ScpTask, ScpTaskProperties> {
    private static final ValidationContext SCP_TASK_CONTEXT = ValidationContext.of((String)"SCP Task");
    private static final String ALL_ARTIFACTS = "all artifacts";
    private boolean localPathAntStyle = false;
    private String localPath;
    private ArtifactItemProperties artifactItem;
    private String remotePath;

    public ScpTask fromLocalPath(String localPath) {
        return this.fromLocalPath(localPath, false);
    }

    public ScpTask fromLocalPath(String localPath, boolean antStyle) {
        ImporterUtils.checkNotEmpty((ValidationContext)SCP_TASK_CONTEXT, (String)"local path", (String)localPath);
        this.localPath = localPath;
        this.localPathAntStyle = antStyle;
        return this;
    }

    @Deprecated
    public ScpTask fromArtifact(String artifactName) {
        ImporterUtils.checkNotEmpty((ValidationContext)SCP_TASK_CONTEXT, (String)"artifact name", (String)artifactName);
        return this.fromArtifact(ScpTask.parseArtifactItemString(artifactName));
    }

    @Deprecated
    public ScpTask fromArtifact(Artifact artifact) {
        ImporterUtils.checkNotNull((ValidationContext)SCP_TASK_CONTEXT, (String)"artifact", (Object)artifact);
        return this.fromArtifact(ScpTask.parseArtifactItemString(artifact.getName()));
    }

    public ScpTask fromArtifact(ArtifactItem artifactItem) {
        ImporterUtils.checkNotNull((ValidationContext)SCP_TASK_CONTEXT, (String)"artifact", (Object)((Object)artifactItem));
        this.artifactItem = (ArtifactItemProperties)EntityPropertiesBuilders.build((EntityPropertiesBuilder)artifactItem);
        return this;
    }

    public ScpTask toRemotePath(String remotePath) {
        ImporterUtils.checkNotEmpty((ValidationContext)SCP_TASK_CONTEXT, (String)"remote path", (String)remotePath);
        this.remotePath = remotePath;
        return this;
    }

    @NotNull
    protected ScpTaskProperties build() {
        return new ScpTaskProperties(this.description, this.taskEnabled, this.host, this.username, this.authenticationType, this.password, this.key, this.passphrase, this.sharedCredentials, this.hostFingerprint, this.port, this.artifactItem, this.localPath, this.localPathAntStyle, this.remotePath);
    }

    public static ArtifactItem parseArtifactItemString(String fullName) {
        ArtifactItem item;
        String artifactName;
        String planQualifierRegExp = "[A-Z][A-Z0-9]{1,}-[A-Z][A-Z0-9]{1,}:.*";
        if (fullName.matches("[A-Z][A-Z0-9]{1,}-[A-Z][A-Z0-9]{1,}:.*")) {
            String[] projectPlanArtifact = StringUtils.split((String)fullName, (String)"-: ", (int)3);
            String projectKey = projectPlanArtifact[0];
            String planKey = projectPlanArtifact[1];
            artifactName = projectPlanArtifact[2];
            item = new ArtifactItem().sourcePlan(new PlanIdentifier(projectKey, planKey));
        } else {
            artifactName = fullName;
            item = new ArtifactItem();
        }
        if (ALL_ARTIFACTS.equals(artifactName)) {
            return item.allArtifacts();
        }
        return item.artifact(artifactName);
    }
}

