/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.model.task;

import com.atlassian.bamboo.specs.api.codegen.annotations.SkipCodeGen;
import com.atlassian.bamboo.specs.api.exceptions.PropertiesValidationException;
import com.atlassian.bamboo.specs.api.model.credentials.SharedCredentialsIdentifierProperties;
import com.atlassian.bamboo.specs.api.model.task.TaskProperties;
import com.atlassian.bamboo.specs.api.util.InliningUtils;
import com.atlassian.bamboo.specs.api.validators.common.ImporterUtils;
import com.atlassian.bamboo.specs.api.validators.common.ValidationContext;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public abstract class BaseSshTaskProperties
extends TaskProperties {
    public static final int DEFAULT_PORT = InliningUtils.preventInlining((int)22);
    private final String host;
    private final String username;
    @SkipCodeGen
    private final AuthenticationType authenticationType;
    @SkipCodeGen
    @Nullable
    private final String password;
    @SkipCodeGen
    @Nullable
    private final String key;
    @SkipCodeGen
    @Nullable
    private final String passphrase;
    @SkipCodeGen
    @Nullable
    private final SharedCredentialsIdentifierProperties sharedCredentialsIdentifierProperties;
    @Nullable
    private final String hostFingerprint;
    private final int port;

    protected BaseSshTaskProperties() {
        this.host = null;
        this.username = null;
        this.authenticationType = null;
        this.password = null;
        this.key = null;
        this.passphrase = null;
        this.sharedCredentialsIdentifierProperties = null;
        this.hostFingerprint = null;
        this.port = DEFAULT_PORT;
    }

    public BaseSshTaskProperties(String description, boolean enabled, String host, String username, AuthenticationType authenticationType, @Nullable String password, @Nullable String key, @Nullable String passphrase, @Nullable SharedCredentialsIdentifierProperties sharedCredentialsIdentifierProperties, @Nullable String hostFingerprint, int port) throws PropertiesValidationException {
        super(description, enabled);
        this.host = host;
        this.username = username;
        this.authenticationType = authenticationType;
        this.password = password;
        this.key = key;
        this.passphrase = passphrase;
        this.sharedCredentialsIdentifierProperties = sharedCredentialsIdentifierProperties;
        this.hostFingerprint = hostFingerprint;
        this.port = port;
    }

    public String getHost() {
        return this.host;
    }

    public String getUsername() {
        return this.username;
    }

    public AuthenticationType getAuthenticationType() {
        return this.authenticationType;
    }

    @Nullable
    public String getPassword() {
        return this.password;
    }

    @Nullable
    public String getKey() {
        return this.key;
    }

    @Nullable
    public String getPassphrase() {
        return this.passphrase;
    }

    @Nullable
    public SharedCredentialsIdentifierProperties getSharedCredentialsIdentifierProperties() {
        return this.sharedCredentialsIdentifierProperties;
    }

    @Nullable
    public String getHostFingerprint() {
        return this.hostFingerprint;
    }

    public int getPort() {
        return this.port;
    }

    public void validate() throws PropertiesValidationException {
        super.validate();
        ValidationContext context = ValidationContext.of((String)"Common SSH task");
        ImporterUtils.checkRequired((ValidationContext)context.with("host"), (Object)this.host);
        ImporterUtils.checkRequired((ValidationContext)context.with("authenticationType"), (Object)((Object)this.authenticationType));
        if (this.sharedCredentialsIdentifierProperties == null) {
            ImporterUtils.checkRequired((ValidationContext)context.with("username"), (Object)this.username);
        }
        ImporterUtils.checkPositive((ValidationContext)context.with("port"), (String)"port", (int)this.port);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BaseSshTaskProperties that = (BaseSshTaskProperties)((Object)o);
        return this.port == that.port && Objects.equals(this.host, that.host) && Objects.equals(this.username, that.username) && this.authenticationType == that.authenticationType && Objects.equals(this.password, that.password) && Objects.equals(this.key, that.key) && Objects.equals(this.passphrase, that.passphrase) && Objects.equals(this.sharedCredentialsIdentifierProperties, that.sharedCredentialsIdentifierProperties) && Objects.equals(this.hostFingerprint, that.hostFingerprint);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.host, this.username, this.authenticationType, this.password, this.key, this.passphrase, this.sharedCredentialsIdentifierProperties, this.hostFingerprint, this.port});
    }

    public static enum AuthenticationType {
        PASSWORD,
        KEY_WITHOUT_PASSPHRASE,
        KEY_WITH_PASSPHRASE;

    }
}

