package com.atlassian.bamboo.specs.model.notification;

import com.atlassian.bamboo.specs.api.codegen.annotations.ConstructFrom;
import com.atlassian.bamboo.specs.api.model.AtlassianModuleProperties;
import com.atlassian.bamboo.specs.api.model.notification.NotificationRecipientProperties;
import com.atlassian.bamboo.specs.api.validators.common.ImporterUtils;
import com.atlassian.bamboo.specs.api.validators.common.ValidationContext;
import org.jetbrains.annotations.NotNull;

import java.util.Objects;

@ConstructFrom({"imAddress"})
public class ImRecipientProperties extends NotificationRecipientProperties {
    private static final AtlassianModuleProperties ATLASSIAN_PLUGIN = new AtlassianModuleProperties("com.atlassian.bamboo.plugin.system.notifications:recipient.im");
    private final String imAddress;

    private ImRecipientProperties() {
        imAddress = null;
    }

    public ImRecipientProperties(@NotNull String imAddress) {
        this.imAddress = imAddress;
        validate();
    }

    public String getImAddress() {
        return imAddress;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ImRecipientProperties that = (ImRecipientProperties) o;
        return Objects.equals(getImAddress(), that.getImAddress());
    }

    @Override
    public int hashCode() {
        return Objects.hash(getImAddress());
    }

    @NotNull
    @Override
    public AtlassianModuleProperties getAtlassianPlugin() {
        return ATLASSIAN_PLUGIN;
    }

    @Override
    public void validate() {
        ValidationContext validationContext = ValidationContext.of("imRecipient");
        ImporterUtils.checkNotBlank(validationContext, "imAddress", imAddress);
    }
}
