/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.model.task;

import com.atlassian.bamboo.specs.api.exceptions.PropertiesValidationException;
import com.atlassian.bamboo.specs.api.model.task.TaskProperties;
import com.atlassian.bamboo.specs.api.validators.common.ImporterUtils;
import com.atlassian.bamboo.specs.api.validators.common.ValidationContext;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseNodeTaskProperties
extends TaskProperties {
    @NotNull
    private String nodeExecutable;
    @Nullable
    private String environmentVariables;
    @Nullable
    private String workingSubdirectory;

    public BaseNodeTaskProperties() {
    }

    public BaseNodeTaskProperties(@Nullable String description, boolean enabled, @NotNull String nodeExecutable, @Nullable String environmentVariables, @Nullable String workingSubdirectory) throws PropertiesValidationException {
        super(description, enabled);
        this.nodeExecutable = nodeExecutable;
        this.environmentVariables = environmentVariables;
        this.workingSubdirectory = workingSubdirectory;
    }

    protected abstract ValidationContext getValidationContext();

    public void validate() {
        super.validate();
        ImporterUtils.checkThat((ValidationContext)this.getValidationContext(), (boolean)StringUtils.isNotBlank((CharSequence)this.nodeExecutable), (String)"Node.js executable is not defined", (Object[])new Object[0]);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BaseNodeTaskProperties)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BaseNodeTaskProperties that = (BaseNodeTaskProperties)((Object)o);
        return Objects.equals(this.getNodeExecutable(), that.getNodeExecutable()) && Objects.equals(this.getEnvironmentVariables(), that.getEnvironmentVariables()) && Objects.equals(this.getWorkingSubdirectory(), that.getWorkingSubdirectory());
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getNodeExecutable(), this.getEnvironmentVariables(), this.getWorkingSubdirectory());
    }

    @NotNull
    public String getNodeExecutable() {
        return this.nodeExecutable;
    }

    @Nullable
    public String getEnvironmentVariables() {
        return this.environmentVariables;
    }

    @Nullable
    public String getWorkingSubdirectory() {
        return this.workingSubdirectory;
    }
}

