/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.model.repository.bitbucket.server;

import com.atlassian.bamboo.specs.api.model.EntityProperties;
import com.atlassian.bamboo.specs.api.validators.common.ImporterUtils;
import com.atlassian.bamboo.specs.api.validators.common.ValidationContext;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;

public class BitbucketServerMirrorProperties
implements EntityProperties {
    public static final ValidationContext VALIDATION_CONTEXT = ValidationContext.of((String)"Bitbucket Server mirror");
    private final String name;
    private final String url;

    private BitbucketServerMirrorProperties() {
        this.name = null;
        this.url = null;
    }

    public BitbucketServerMirrorProperties(@Nullable String name, @Nullable String url) {
        this.name = name;
        this.url = url;
        this.validate();
    }

    public String getName() {
        return this.name;
    }

    public String getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BitbucketServerMirrorProperties that = (BitbucketServerMirrorProperties)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.url, that.url);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.url);
    }

    public void validate() {
        ImporterUtils.checkThat((ValidationContext)VALIDATION_CONTEXT, (StringUtils.isNotBlank((CharSequence)this.url) || StringUtils.isNotBlank((CharSequence)this.name) ? 1 : 0) != 0, (String)"Either url or name must be specified", (Object[])new Object[0]);
    }
}

