/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.model.task;

import com.atlassian.bamboo.specs.api.exceptions.PropertiesValidationException;
import com.atlassian.bamboo.specs.api.model.AtlassianModuleProperties;
import com.atlassian.bamboo.specs.api.model.plan.requirement.RequirementProperties;
import com.atlassian.bamboo.specs.api.model.task.TaskProperties;
import com.atlassian.bamboo.specs.api.util.InliningUtils;
import com.atlassian.bamboo.specs.api.validators.common.ImporterUtils;
import com.atlassian.bamboo.specs.api.validators.common.ValidationContext;
import com.atlassian.bamboo.specs.model.task.InjectVariablesScope;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import javax.annotation.concurrent.Immutable;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Immutable
public final class InjectVariablesTaskProperties
extends TaskProperties {
    private static final AtlassianModuleProperties ATLASSIAN_PLUGIN = new AtlassianModuleProperties("com.atlassian.bamboo.plugins.bamboo-variable-inject-plugin:inject");
    public static final Pattern VALID_NAMESPACE_PATTERN = Pattern.compile("[a-z0-9_\\.]+", 2);
    public static final String DEFAULT_NAMESPACE = InliningUtils.preventInlining((String)"inject");
    @NotNull
    private final String path;
    @NotNull
    private final String namespace;
    @NotNull
    private final InjectVariablesScope scope;

    protected InjectVariablesTaskProperties() {
        this.path = null;
        this.namespace = null;
        this.scope = null;
    }

    public InjectVariablesTaskProperties(@Nullable String description, boolean enabled, @NotNull String path, @NotNull String namespace, @NotNull InjectVariablesScope scope, @NotNull List<RequirementProperties> requirements) throws PropertiesValidationException {
        super(description, enabled, requirements);
        this.path = path;
        this.namespace = namespace;
        this.scope = scope;
        this.validate();
    }

    @NotNull
    public AtlassianModuleProperties getAtlassianPlugin() {
        return ATLASSIAN_PLUGIN;
    }

    @NotNull
    public String getPath() {
        return this.path;
    }

    @NotNull
    public String getNamespace() {
        return this.namespace;
    }

    @NotNull
    public InjectVariablesScope getScope() {
        return this.scope;
    }

    public void validate() {
        super.validate();
        ValidationContext context = ValidationContext.of((String)"Inject variables task");
        ImporterUtils.checkThat((ValidationContext)context, (boolean)StringUtils.isNotBlank((CharSequence)this.path), (String)"Path is not defined", (Object[])new Object[0]);
        ImporterUtils.checkThat((ValidationContext)context, (boolean)StringUtils.isNotBlank((CharSequence)this.namespace), (String)"Namespace is not defined", (Object[])new Object[0]);
        ImporterUtils.checkThat((ValidationContext)context, (boolean)VALID_NAMESPACE_PATTERN.matcher(this.namespace).matches(), (String)"Namespace must be alphanumeric", (Object[])new Object[0]);
        ImporterUtils.checkThat((ValidationContext)context, (this.scope != null ? 1 : 0) != 0, (String)"Scope is not defined", (Object[])new Object[0]);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InjectVariablesTaskProperties)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        InjectVariablesTaskProperties that = (InjectVariablesTaskProperties)((Object)o);
        return Objects.equals(this.getPath(), that.getPath()) && Objects.equals(this.getNamespace(), that.getNamespace()) && Objects.equals((Object)this.getScope(), (Object)that.getScope());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.getPath(), this.getNamespace(), this.getScope()});
    }
}

