/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.util;

import com.atlassian.bamboo.specs.util.CustomYamlers;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.error.YAMLException;
import org.yaml.snakeyaml.nodes.Tag;

public class WhitelistedYamlConstructor
extends Constructor {
    private static final Set<Pattern> WHITELISTED_CLASSES = Collections.unmodifiableSet(new HashSet<Pattern>(){
        {
            this.add(Pattern.compile("com\\.atlassian\\.bamboo\\.specs\\.util\\.BambooSpecProperties"));
            this.add(Pattern.compile("com\\.atlassian\\.bamboo\\.specs\\.api\\.model\\..*Properties"));
            this.add(Pattern.compile("com\\.atlassian\\.bamboo\\.specs\\.api\\.model\\..*Properties\\$.+"));
            this.add(Pattern.compile("com\\.atlassian\\.bamboo\\.specs\\.model\\..*Properties"));
            this.add(Pattern.compile("com\\.atlassian\\.bamboo\\.specs\\.model\\..*Properties\\$.+"));
            this.add(Pattern.compile("com\\.atlassian\\.bamboo\\.specs\\.api\\.builders\\.Applicability"));
            this.add(Pattern.compile("com\\.atlassian\\.bamboo\\.specs\\.api\\.builders\\.permission\\.PermissionType"));
        }
    });

    WhitelistedYamlConstructor() {
        for (CustomYamlers.CustomYamler customYamler : CustomYamlers.YAMLERS) {
            this.yamlConstructors.put(new Tag(customYamler.getYamledClass()), customYamler.getConstructor());
        }
    }

    boolean isClassAllowed(String fullClassName) {
        return WHITELISTED_CLASSES.stream().anyMatch(pattern -> pattern.matcher(fullClassName).matches());
    }

    protected Class<?> getClassForName(String name) throws ClassNotFoundException {
        if (this.isClassAllowed(name)) {
            return super.getClassForName(name);
        }
        throw new YAMLException(String.format("Class '%s' is not allowed in YAML.", name));
    }
}

