/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.model.task;

import com.atlassian.bamboo.specs.api.builders.Applicability;
import com.atlassian.bamboo.specs.api.codegen.annotations.CodeGenerator;
import com.atlassian.bamboo.specs.api.exceptions.PropertiesValidationException;
import com.atlassian.bamboo.specs.api.model.AtlassianModuleProperties;
import com.atlassian.bamboo.specs.api.model.plan.requirement.RequirementProperties;
import com.atlassian.bamboo.specs.api.model.task.TaskProperties;
import com.atlassian.bamboo.specs.api.validators.common.ImporterUtils;
import com.atlassian.bamboo.specs.api.validators.common.ValidationContext;
import com.atlassian.bamboo.specs.builders.task.NUnitRunnerTask;
import com.atlassian.bamboo.specs.codegen.emitters.task.NUnitVersionEmitter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NUnitRunnerTaskProperties
extends TaskProperties {
    private static final AtlassianModuleProperties NUNIT_ATLASSIAN_PLUGIN = new AtlassianModuleProperties("com.atlassian.bamboo.plugin.dotnet:nunitRunner");
    private static final ValidationContext VALIDATION_CONTEXT = ValidationContext.of((String)"NUnit runner task");
    private final String executable;
    @CodeGenerator(value=NUnitVersionEmitter.class)
    private final NUnitRunnerTask.NUnitVersion nUnitVersion;
    private final String nUnitTestFiles;
    private final String resultFilename;
    private final List<String> testsToRun;
    private final List<String> testCategoriesToInclude;
    private final List<String> testCategoriesToExclude;
    @Nullable
    private final String commandLineOptions;
    @Nullable
    private final String environmentVariables;

    private NUnitRunnerTaskProperties() {
        this.executable = null;
        this.nUnitVersion = null;
        this.nUnitTestFiles = null;
        this.resultFilename = null;
        this.testsToRun = null;
        this.testCategoriesToInclude = null;
        this.testCategoriesToExclude = null;
        this.commandLineOptions = null;
        this.environmentVariables = null;
    }

    public NUnitRunnerTaskProperties(@Nullable String description, boolean enabled, @NotNull String executable, @NotNull NUnitRunnerTask.NUnitVersion nUnitVersion, @NotNull String nUnitTestFiles, @NotNull String resultFilename, @NotNull List<String> testsToRun, @NotNull List<String> testCategoriesToInclude, @NotNull List<String> testCategoriesToExclude, @Nullable String commandLineOptions, @Nullable String environmentVariables, @NotNull List<RequirementProperties> requirements) throws PropertiesValidationException {
        super(description, enabled, requirements);
        this.executable = executable;
        this.nUnitVersion = nUnitVersion;
        this.nUnitTestFiles = nUnitTestFiles;
        this.resultFilename = resultFilename;
        this.testsToRun = Collections.unmodifiableList(new ArrayList<String>(testsToRun));
        this.testCategoriesToInclude = Collections.unmodifiableList(new ArrayList<String>(testCategoriesToInclude));
        this.testCategoriesToExclude = Collections.unmodifiableList(new ArrayList<String>(testCategoriesToExclude));
        this.commandLineOptions = commandLineOptions;
        this.environmentVariables = environmentVariables;
        this.validate();
    }

    @NotNull
    public AtlassianModuleProperties getAtlassianPlugin() {
        return NUNIT_ATLASSIAN_PLUGIN;
    }

    @NotNull
    public String getExecutable() {
        return this.executable;
    }

    @NotNull
    public NUnitRunnerTask.NUnitVersion getNUnitVersion() {
        return this.nUnitVersion;
    }

    @NotNull
    public String getNUnitTestFiles() {
        return this.nUnitTestFiles;
    }

    @NotNull
    public String getResultFilename() {
        return this.resultFilename;
    }

    @NotNull
    public List<String> getTestsToRun() {
        return this.testsToRun;
    }

    @NotNull
    public List<String> getTestCategoriesToInclude() {
        return this.testCategoriesToInclude;
    }

    @NotNull
    public List<String> getTestCategoriesToExclude() {
        return this.testCategoriesToExclude;
    }

    @Nullable
    public String getCommandLineOptions() {
        return this.commandLineOptions;
    }

    @Nullable
    public String getEnvironmentVariables() {
        return this.environmentVariables;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NUnitRunnerTaskProperties that = (NUnitRunnerTaskProperties)((Object)o);
        return Objects.equals(this.executable, that.executable) && Objects.equals((Object)this.nUnitVersion, (Object)that.nUnitVersion) && Objects.equals(this.nUnitTestFiles, that.nUnitTestFiles) && Objects.equals(this.resultFilename, that.resultFilename) && Objects.equals(this.testsToRun, that.testsToRun) && Objects.equals(this.testCategoriesToInclude, that.testCategoriesToInclude) && Objects.equals(this.testCategoriesToExclude, that.testCategoriesToExclude) && Objects.equals(this.commandLineOptions, that.commandLineOptions) && Objects.equals(this.environmentVariables, that.environmentVariables);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.executable, this.nUnitVersion, this.nUnitTestFiles, this.resultFilename, this.testsToRun, this.testCategoriesToInclude, this.testCategoriesToExclude, this.commandLineOptions, this.environmentVariables});
    }

    public void validate() {
        super.validate();
        ImporterUtils.checkNotBlank((ValidationContext)VALIDATION_CONTEXT, (String)"executable", (String)this.executable);
        ImporterUtils.checkNotNull((ValidationContext)VALIDATION_CONTEXT, (String)"nUnitVersion", (Object)((Object)this.nUnitVersion));
        ImporterUtils.checkNotBlank((ValidationContext)VALIDATION_CONTEXT, (String)"nUnitTestFiles", (String)this.nUnitTestFiles);
        ImporterUtils.checkNotBlank((ValidationContext)VALIDATION_CONTEXT, (String)"resultFilename", (String)this.resultFilename);
        ImporterUtils.checkNotNull((ValidationContext)VALIDATION_CONTEXT, (String)"testsToRun", this.testsToRun);
        ImporterUtils.checkNotNull((ValidationContext)VALIDATION_CONTEXT, (String)"testCategoriesToInclude", this.testCategoriesToInclude);
        ImporterUtils.checkNotNull((ValidationContext)VALIDATION_CONTEXT, (String)"testCategoriesToExclude", this.testCategoriesToExclude);
    }

    public EnumSet<Applicability> applicableTo() {
        return EnumSet.of(Applicability.PLANS);
    }
}

