/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.model.task;

import com.atlassian.bamboo.specs.api.exceptions.PropertiesValidationException;
import com.atlassian.bamboo.specs.api.model.AtlassianModuleProperties;
import com.atlassian.bamboo.specs.api.model.plan.requirement.RequirementProperties;
import com.atlassian.bamboo.specs.api.validators.common.ImporterUtils;
import com.atlassian.bamboo.specs.api.validators.common.ValidationContext;
import com.atlassian.bamboo.specs.model.task.BaseNodeTaskProperties;
import java.util.List;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Immutable
public final class NpmTaskProperties
extends BaseNodeTaskProperties {
    private static final AtlassianModuleProperties ATLASSIAN_PLUGIN = new AtlassianModuleProperties("com.atlassian.bamboo.plugins.bamboo-nodejs-plugin:task.builder.npm");
    public static final ValidationContext VALIDATION_CONTEXT = ValidationContext.of((String)"npm task");
    @NotNull
    private String command;
    private boolean useIsolatedCache;

    protected NpmTaskProperties() {
    }

    public NpmTaskProperties(@Nullable String description, boolean enabled, @NotNull String nodeExecutable, @Nullable String environmentVariables, @Nullable String workingSubdirectory, @NotNull String command, boolean useIsolatedCache, @NotNull List<RequirementProperties> requirements) throws PropertiesValidationException {
        super(description, enabled, nodeExecutable, environmentVariables, workingSubdirectory, requirements);
        this.command = command;
        this.useIsolatedCache = useIsolatedCache;
        this.validate();
    }

    @Override
    public void validate() {
        super.validate();
        ImporterUtils.checkThat((ValidationContext)this.getValidationContext(), (boolean)StringUtils.isNotBlank((CharSequence)this.command), (String)"Command is not defined", (Object[])new Object[0]);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NpmTaskProperties)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NpmTaskProperties that = (NpmTaskProperties)((Object)o);
        return this.isUseIsolatedCache() == that.isUseIsolatedCache() && Objects.equals(this.getCommand(), that.getCommand());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getCommand(), this.isUseIsolatedCache());
    }

    @NotNull
    public AtlassianModuleProperties getAtlassianPlugin() {
        return ATLASSIAN_PLUGIN;
    }

    @Override
    protected ValidationContext getValidationContext() {
        return VALIDATION_CONTEXT;
    }

    @NotNull
    public String getCommand() {
        return this.command;
    }

    public boolean isUseIsolatedCache() {
        return this.useIsolatedCache;
    }
}

