/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.codegen.emitters.value;

import com.atlassian.bamboo.specs.api.codegen.CodeEmitter;
import com.atlassian.bamboo.specs.api.codegen.CodeGenerationException;
import com.atlassian.bamboo.specs.api.model.EntityProperties;
import com.atlassian.bamboo.specs.codegen.emitters.CodeGenerationUtils;
import com.atlassian.bamboo.specs.codegen.emitters.value.DurationEmitter;
import com.atlassian.bamboo.specs.codegen.emitters.value.EntityPropertiesEmitter;
import com.atlassian.bamboo.specs.codegen.emitters.value.LiteralEmitter;
import com.atlassian.bamboo.specs.codegen.emitters.value.MapEmitter;
import java.time.Duration;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public final class ValueEmitterFactory {
    private ValueEmitterFactory() {
    }

    public static <T extends EntityProperties> CodeEmitter<T> emitterFor(@NotNull T entity) throws CodeGenerationException {
        CodeEmitter codeEmitter = CodeGenerationUtils.findEmitterByAnnotation(entity.getClass());
        if (codeEmitter != null) {
            return codeEmitter;
        }
        return new EntityPropertiesEmitter();
    }

    public static <T> CodeEmitter<T> emitterFor(@NotNull T object) throws CodeGenerationException {
        if (object instanceof EntityProperties) {
            return ValueEmitterFactory.emitterFor((EntityProperties)object);
        }
        if (object instanceof Duration) {
            return new DurationEmitter();
        }
        if (object instanceof Map) {
            return new MapEmitter();
        }
        if (object instanceof Collection) {
            throw new CodeGenerationException("Generating code for collections is not supported yet");
        }
        return new LiteralEmitter();
    }
}

