/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.model.task;

import com.atlassian.bamboo.specs.api.codegen.annotations.CodeGenerator;
import com.atlassian.bamboo.specs.api.codegen.annotations.Setter;
import com.atlassian.bamboo.specs.api.codegen.annotations.SkipCodeGen;
import com.atlassian.bamboo.specs.api.exceptions.PropertiesValidationException;
import com.atlassian.bamboo.specs.api.model.AtlassianModuleProperties;
import com.atlassian.bamboo.specs.api.model.plan.requirement.RequirementProperties;
import com.atlassian.bamboo.specs.api.model.task.TaskProperties;
import com.atlassian.bamboo.specs.api.validators.common.ImporterUtils;
import com.atlassian.bamboo.specs.api.validators.common.ValidationContext;
import com.atlassian.bamboo.specs.builders.task.MavenTask;
import com.atlassian.bamboo.specs.codegen.emitters.task.MavenVersionEmitter;
import java.util.List;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Immutable
public final class MavenTaskProperties
extends TaskProperties {
    private static final AtlassianModuleProperties V2_PLUGIN = new AtlassianModuleProperties("com.atlassian.bamboo.plugins.maven:task.builder.mvn2");
    private static final AtlassianModuleProperties V3_PLUGIN = new AtlassianModuleProperties("com.atlassian.bamboo.plugins.maven:task.builder.mvn3");
    @NotNull
    protected String goal;
    @Nullable
    protected String projectFile;
    @Nullable
    protected String environmentVariables;
    @Nullable
    protected String jdk;
    @Nullable
    protected String executableLabel;
    protected boolean hasTests;
    @SkipCodeGen
    @Nullable
    protected MavenTask.TestDirectoryOption testDirectoryOption = MavenTask.TestDirectoryOption.STANDARD;
    @Setter(value="testResultsPath")
    @Nullable
    protected String testResultsDirectory;
    @Nullable
    protected String workingSubdirectory;
    protected boolean useMavenReturnCode;
    @CodeGenerator(value=MavenVersionEmitter.class)
    protected int version = 3;

    private MavenTaskProperties() {
    }

    public MavenTaskProperties(@Nullable String description, boolean enabled, @NotNull String goal, @Nullable String projectFile, @Nullable String environmentVariables, @Nullable String jdk, @NotNull String executableLabel, boolean hasTests, @Nullable MavenTask.TestDirectoryOption testDirectoryOption, @Nullable String testResultsDirectory, @Nullable String workingSubdirectory, boolean useMavenReturnCode, int version, @NotNull List<RequirementProperties> requirements) throws PropertiesValidationException {
        super(description, enabled, requirements);
        this.goal = goal;
        this.projectFile = projectFile;
        this.environmentVariables = environmentVariables;
        this.jdk = jdk;
        this.executableLabel = executableLabel;
        this.hasTests = hasTests;
        if (testDirectoryOption != null) {
            this.testDirectoryOption = testDirectoryOption;
        }
        this.testResultsDirectory = testResultsDirectory;
        this.workingSubdirectory = workingSubdirectory;
        this.useMavenReturnCode = useMavenReturnCode;
        this.version = version;
        this.validate();
    }

    @NotNull
    public String getGoal() {
        return this.goal;
    }

    @Nullable
    public String getProjectFile() {
        return this.projectFile;
    }

    @Nullable
    public String getEnvironmentVariables() {
        return this.environmentVariables;
    }

    @Nullable
    public String getJdk() {
        return this.jdk;
    }

    @Nullable
    public String getExecutableLabel() {
        return this.executableLabel;
    }

    public boolean isHasTests() {
        return this.hasTests;
    }

    @NotNull
    public MavenTask.TestDirectoryOption getTestDirectoryOption() {
        return this.testDirectoryOption;
    }

    @Nullable
    public String getTestResultsDirectory() {
        return this.testResultsDirectory;
    }

    @Nullable
    public String getWorkingSubdirectory() {
        return this.workingSubdirectory;
    }

    public boolean isUseMavenReturnCode() {
        return this.useMavenReturnCode;
    }

    @NotNull
    public int getVersion() {
        return this.version;
    }

    @NotNull
    public AtlassianModuleProperties getAtlassianPlugin() {
        if (this.version == 2) {
            return V2_PLUGIN;
        }
        if (this.version == 3) {
            return V3_PLUGIN;
        }
        throw new IllegalStateException("Version " + this.version + " is not supported. Please use values: 2 or 3");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MavenTaskProperties that = (MavenTaskProperties)((Object)o);
        return this.hasTests == that.hasTests && this.useMavenReturnCode == that.useMavenReturnCode && this.version == that.version && Objects.equals(this.goal, that.goal) && Objects.equals(this.projectFile, that.projectFile) && Objects.equals(this.environmentVariables, that.environmentVariables) && Objects.equals(this.jdk, that.jdk) && Objects.equals(this.executableLabel, that.executableLabel) && this.testDirectoryOption == that.testDirectoryOption && Objects.equals(this.testResultsDirectory, that.testResultsDirectory) && Objects.equals(this.workingSubdirectory, that.workingSubdirectory);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.goal, this.projectFile, this.environmentVariables, this.jdk, this.executableLabel, this.hasTests, this.testDirectoryOption, this.testResultsDirectory, this.workingSubdirectory, this.useMavenReturnCode, this.version});
    }

    public void validate() {
        super.validate();
        ValidationContext context = ValidationContext.of((String)"Maven task");
        ImporterUtils.checkThat((ValidationContext)context, (boolean)StringUtils.isNotBlank((CharSequence)this.goal), (String)"Goal is not defined", (Object[])new Object[0]);
        ImporterUtils.checkThat((ValidationContext)context, (boolean)StringUtils.isNotBlank((CharSequence)this.executableLabel), (String)"Executable label is not defined", (Object[])new Object[0]);
        ImporterUtils.checkThat((ValidationContext)context, (this.version == 2 || this.version == 3 ? 1 : 0) != 0, (String)("Only versions 2 or 3 are supported, not " + this.version), (Object[])new Object[0]);
    }
}

