/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.model.task;

import com.atlassian.bamboo.specs.api.exceptions.PropertiesValidationException;
import com.atlassian.bamboo.specs.api.model.AtlassianModuleProperties;
import com.atlassian.bamboo.specs.api.model.plan.requirement.RequirementProperties;
import com.atlassian.bamboo.specs.api.validators.common.ImporterUtils;
import com.atlassian.bamboo.specs.api.validators.common.ValidationContext;
import com.atlassian.bamboo.specs.builders.task.MochaRunnerTask;
import com.atlassian.bamboo.specs.model.task.BaseNodeTaskProperties;
import java.util.List;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Immutable
public final class MochaRunnerTaskProperties
extends BaseNodeTaskProperties {
    private static final AtlassianModuleProperties ATLASSIAN_PLUGIN = new AtlassianModuleProperties("com.atlassian.bamboo.plugins.bamboo-nodejs-plugin:task.builder.mocha");
    public static final ValidationContext VALIDATION_CONTEXT = ValidationContext.of((String)"Mocha runner task");
    @NotNull
    private String mochaExecutable = MochaRunnerTask.DEFAULT_MOCHA_EXECUTABLE;
    @NotNull
    private String testFilesAndDirectories = MochaRunnerTask.DEFAULT_TEST_DIRECTORY;
    private boolean parseTestResults = MochaRunnerTask.DEFAULT_PARSE_TEST_RESULTS;
    @Nullable
    private String arguments;

    protected MochaRunnerTaskProperties() {
    }

    public MochaRunnerTaskProperties(@Nullable String description, boolean enabled, @NotNull String nodeExecutable, @Nullable String environmentVariables, @Nullable String workingSubdirectory, @NotNull String mochaExecutable, @NotNull String testFilesAndDirectories, boolean parseTestResults, @Nullable String arguments, @NotNull List<RequirementProperties> requirements) throws PropertiesValidationException {
        super(description, enabled, nodeExecutable, environmentVariables, workingSubdirectory, requirements);
        this.mochaExecutable = mochaExecutable;
        this.testFilesAndDirectories = testFilesAndDirectories;
        this.parseTestResults = parseTestResults;
        this.arguments = arguments;
        this.validate();
    }

    @Override
    public void validate() {
        super.validate();
        ImporterUtils.checkThat((ValidationContext)this.getValidationContext(), (boolean)StringUtils.isNotBlank((CharSequence)this.mochaExecutable), (String)"Mocha executable is not defined", (Object[])new Object[0]);
        ImporterUtils.checkThat((ValidationContext)this.getValidationContext(), (boolean)StringUtils.isNotBlank((CharSequence)this.testFilesAndDirectories), (String)"Files and/or directories containing Mocha tests are not defined", (Object[])new Object[0]);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MochaRunnerTaskProperties)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MochaRunnerTaskProperties that = (MochaRunnerTaskProperties)((Object)o);
        return this.isParseTestResults() == that.isParseTestResults() && Objects.equals(this.getMochaExecutable(), that.getMochaExecutable()) && Objects.equals(this.getTestFilesAndDirectories(), that.getTestFilesAndDirectories()) && Objects.equals(this.getArguments(), that.getArguments());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getMochaExecutable(), this.getTestFilesAndDirectories(), this.isParseTestResults(), this.getArguments());
    }

    @NotNull
    public AtlassianModuleProperties getAtlassianPlugin() {
        return ATLASSIAN_PLUGIN;
    }

    @Override
    protected ValidationContext getValidationContext() {
        return VALIDATION_CONTEXT;
    }

    @NotNull
    public String getMochaExecutable() {
        return this.mochaExecutable;
    }

    @NotNull
    public String getTestFilesAndDirectories() {
        return this.testFilesAndDirectories;
    }

    public boolean isParseTestResults() {
        return this.parseTestResults;
    }

    @Nullable
    public String getArguments() {
        return this.arguments;
    }
}

