/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.codegen.emitters.task;

import com.atlassian.bamboo.specs.api.builders.credentials.SharedCredentialsIdentifier;
import com.atlassian.bamboo.specs.api.codegen.CodeGenerationContext;
import com.atlassian.bamboo.specs.api.codegen.CodeGenerationException;
import com.atlassian.bamboo.specs.api.model.credentials.SharedCredentialsIdentifierProperties;
import com.atlassian.bamboo.specs.builders.task.DockerPullImageTask;
import com.atlassian.bamboo.specs.builders.task.DockerPushImageTask;
import com.atlassian.bamboo.specs.codegen.emitters.value.EntityPropertiesEmitter;
import com.atlassian.bamboo.specs.model.task.docker.DockerRegistryTaskProperties;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class DockerRegistryEmitter
extends EntityPropertiesEmitter<DockerRegistryTaskProperties> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public String emitCode(@NotNull CodeGenerationContext context, @NotNull DockerRegistryTaskProperties entity) throws CodeGenerationException {
        switch (entity.getOperationType()) {
            case PUSH: {
                this.builderClass = DockerPushImageTask.class;
                break;
            }
            case PULL: {
                this.builderClass = DockerPullImageTask.class;
                break;
            }
            default: {
                throw new IllegalStateException("Invalid operation type: " + (Object)((Object)entity.getOperationType()));
            }
        }
        this.fieldsToSkip.add("operationType");
        this.fieldsToSkip.add("registryType");
        this.fieldsToSkip.add("image");
        this.fieldsToSkip.add("username");
        this.fieldsToSkip.add("password");
        this.fieldsToSkip.add("email");
        String constructorInvocation = this.emitConstructorInvocation(context, entity);
        context.incIndentation();
        try {
            String string = String.format("%s%s.%s%s.%s", constructorInvocation, context.newLine(), this.emitImageCode(entity), context.newLine(), this.emitAuthenticationCode(entity, context));
            return string;
        }
        finally {
            context.decIndentation();
        }
    }

    protected String emitAuthenticationCode(DockerRegistryTaskProperties entity, CodeGenerationContext context) {
        SharedCredentialsIdentifierProperties sharedCredentials = entity.getSharedCredentialsIdentifier();
        if (sharedCredentials != null) {
            context.importClassName(SharedCredentialsIdentifier.class);
            return String.format("authentication(new SharedCredentialsIdentifier(\"%s\"))", sharedCredentials.getName());
        }
        if (StringUtils.isNotBlank((CharSequence)entity.getUsername()) && StringUtils.isNotBlank((CharSequence)entity.getPassword())) {
            String escapedUsername = this.escapeString(entity.getUsername());
            if (StringUtils.isNotBlank((CharSequence)entity.getEmail())) {
                String escapedEmail = this.escapeString(entity.getEmail());
                return String.format("authentication(\"%s\",%s,\"%s\")", escapedUsername, " /*FIXME put your password here*/", escapedEmail);
            }
            return String.format("authentication(\"%s\",%s)", escapedUsername, " /*FIXME put your password here*/");
        }
        return "defaultAuthentication()";
    }

    private String escapeString(String property) {
        return property.replaceAll("\"", "\\\\\"");
    }

    protected String emitImageCode(DockerRegistryTaskProperties entity) {
        switch (entity.getRegistryType()) {
            case DOCKER_HUB: {
                return String.format("dockerHubImage(\"%s\")", entity.getImage());
            }
            case CUSTOM: {
                return String.format("customRegistryImage(\"%s\")", entity.getImage());
            }
        }
        throw new IllegalStateException("Invalid registry type: " + (Object)((Object)entity.getOperationType()));
    }
}

