/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.model.task;

import com.atlassian.bamboo.specs.api.exceptions.PropertiesValidationException;
import com.atlassian.bamboo.specs.api.model.AtlassianModuleProperties;
import com.atlassian.bamboo.specs.api.model.plan.requirement.RequirementProperties;
import com.atlassian.bamboo.specs.api.validators.common.ImporterUtils;
import com.atlassian.bamboo.specs.api.validators.common.ValidationContext;
import com.atlassian.bamboo.specs.builders.task.NodeunitTask;
import com.atlassian.bamboo.specs.model.task.BaseNodeTaskProperties;
import java.util.List;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Immutable
public final class NodeunitTaskProperties
extends BaseNodeTaskProperties {
    private static final AtlassianModuleProperties ATLASSIAN_PLUGIN = new AtlassianModuleProperties("com.atlassian.bamboo.plugins.bamboo-nodejs-plugin:task.builder.nodeunit");
    public static final ValidationContext VALIDATION_CONTEXT = ValidationContext.of((String)"Nodeunit task");
    @NotNull
    private String nodeunitExecutable = NodeunitTask.DEFAULT_NODEUNIT_EXECUTABLE;
    @NotNull
    private String testFilesAndDirectories = NodeunitTask.DEFAULT_TEST_DIRECTORY;
    @NotNull
    private String testResultsDirectory = NodeunitTask.DEFAULT_RESULTS_DIRECTORY;
    private boolean parseTestResults = NodeunitTask.DEFAULT_PARSE_TEST_RESULTS;
    @Nullable
    private String arguments;

    protected NodeunitTaskProperties() {
    }

    public NodeunitTaskProperties(@Nullable String description, boolean enabled, @NotNull String nodeExecutable, @Nullable String environmentVariables, @Nullable String workingSubdirectory, @NotNull String nodeunitExecutable, @NotNull String testFilesAndDirectories, @NotNull String testResultsDirectory, boolean parseTestResults, @Nullable String arguments, @NotNull List<RequirementProperties> requirements) throws PropertiesValidationException {
        super(description, enabled, nodeExecutable, environmentVariables, workingSubdirectory, requirements);
        this.nodeunitExecutable = nodeunitExecutable;
        this.testFilesAndDirectories = testFilesAndDirectories;
        this.testResultsDirectory = testResultsDirectory;
        this.parseTestResults = parseTestResults;
        this.arguments = arguments;
        this.validate();
    }

    @Override
    public void validate() {
        super.validate();
        ImporterUtils.checkThat((ValidationContext)this.getValidationContext(), (boolean)StringUtils.isNotBlank((CharSequence)this.nodeunitExecutable), (String)"Nodeunit executable is not defined", (Object[])new Object[0]);
        ImporterUtils.checkThat((ValidationContext)this.getValidationContext(), (boolean)StringUtils.isNotBlank((CharSequence)this.testFilesAndDirectories), (String)"Files and/or directories containing Nodeunit tests are not defined", (Object[])new Object[0]);
        ImporterUtils.checkThat((ValidationContext)this.getValidationContext(), (boolean)StringUtils.isNotBlank((CharSequence)this.testResultsDirectory), (String)"Test results directory is not defined", (Object[])new Object[0]);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NodeunitTaskProperties)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NodeunitTaskProperties that = (NodeunitTaskProperties)((Object)o);
        return this.isParseTestResults() == that.isParseTestResults() && Objects.equals(this.getNodeunitExecutable(), that.getNodeunitExecutable()) && Objects.equals(this.getTestFilesAndDirectories(), that.getTestFilesAndDirectories()) && Objects.equals(this.getTestResultsDirectory(), that.getTestResultsDirectory()) && Objects.equals(this.getArguments(), that.getArguments());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getNodeunitExecutable(), this.getTestFilesAndDirectories(), this.getTestResultsDirectory(), this.isParseTestResults(), this.getArguments());
    }

    @NotNull
    public AtlassianModuleProperties getAtlassianPlugin() {
        return ATLASSIAN_PLUGIN;
    }

    @Override
    protected ValidationContext getValidationContext() {
        return VALIDATION_CONTEXT;
    }

    @NotNull
    public String getNodeunitExecutable() {
        return this.nodeunitExecutable;
    }

    @NotNull
    public String getTestFilesAndDirectories() {
        return this.testFilesAndDirectories;
    }

    @NotNull
    public String getTestResultsDirectory() {
        return this.testResultsDirectory;
    }

    public boolean isParseTestResults() {
        return this.parseTestResults;
    }

    @Nullable
    public String getArguments() {
        return this.arguments;
    }
}

