/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.codegen;

import com.atlassian.bamboo.specs.api.BambooSpec;
import com.atlassian.bamboo.specs.api.codegen.CodeEmitter;
import com.atlassian.bamboo.specs.api.codegen.CodeGenerationContext;
import com.atlassian.bamboo.specs.api.codegen.CodeGenerationException;
import com.atlassian.bamboo.specs.api.exceptions.PropertiesValidationException;
import com.atlassian.bamboo.specs.api.model.EntityProperties;
import com.atlassian.bamboo.specs.api.validators.common.ImporterUtils;
import com.atlassian.bamboo.specs.codegen.BuilderClassProvider;
import com.atlassian.bamboo.specs.codegen.emitters.value.ValueEmitterFactory;
import com.atlassian.bamboo.specs.util.BambooServer;
import com.atlassian.bamboo.specs.util.BambooSpecProperties;
import com.atlassian.bamboo.specs.util.Yamlizator;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.concurrent.Immutable;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class BambooSpecsGenerator {
    private final Map<String, EntityProperties> entityByName = new LinkedHashMap<String, EntityProperties>();
    private final CodeGenerationContext context = new CodeGenerationContext();

    public BambooSpecsGenerator() {
    }

    public BambooSpecsGenerator(EntityProperties entityProperties) throws PropertiesValidationException {
        this();
        this.addEntity("rootObject", entityProperties);
    }

    public BambooSpecsGenerator addEntity(String entityName, EntityProperties entityProperties) throws PropertiesValidationException {
        ImporterUtils.checkNotNull((String)"entity name", (Object)entityName);
        ImporterUtils.checkNotNull((String)"entity", (Object)entityProperties);
        if (this.entityByName.putIfAbsent(entityName, entityProperties) != null) {
            throw new PropertiesValidationException(String.format("Entity with name %s already defined.", entityName));
        }
        return this;
    }

    private StringBuilder classDeclaration(@NotNull Set<Class> annotations, @NotNull String className, @NotNull CodeSupplier body) throws CodeGenerationException {
        StringBuilder builder = new StringBuilder();
        for (Class annotation : annotations) {
            String annotationName = this.context.importClassName(annotation);
            builder.append("@").append(annotationName).append(this.context.newLine());
        }
        builder.append("public class ").append(className).append(" {");
        this.context.incIndentation();
        builder.append(body.generateCode());
        this.context.decIndentation();
        builder.append(this.context.newLine());
        builder.append("}");
        this.context.decIndentation();
        builder.append(this.context.newLine());
        builder.append("}");
        return builder;
    }

    private String buildCode(String url, String className) throws CodeGenerationException {
        String mainObjectName = this.getMainObjectName(className);
        StringBuilder builder = this.classDeclaration(Collections.singleton(BambooSpec.class), className, () -> {
            StringBuilder bodyBuilder = new StringBuilder();
            for (String entityName : this.entityByName.keySet()) {
                this.insertCreationMethod(bodyBuilder, entityName, this.entityByName.get(entityName));
            }
            bodyBuilder.append(this.context.newLine());
            bodyBuilder.append(this.context.newLine());
            bodyBuilder.append("public static void main(String... argv) {");
            this.context.incIndentation();
            bodyBuilder.append(this.context.newLine());
            bodyBuilder.append("//By default credentials are read from the '.credentials' file.").append(this.context.newLine());
            bodyBuilder.append(this.context.importClassName(BambooServer.class)).append(" bambooServer = new BambooServer(\"").append(url).append("\");");
            bodyBuilder.append(this.context.newLine());
            bodyBuilder.append("final ").append(className).append(" " + mainObjectName + " = new ").append(className).append("();");
            for (String entityName : this.entityByName.keySet()) {
                bodyBuilder.append(this.context.newLine()).append(this.context.newLine());
                this.insertPublishingCode(bodyBuilder, mainObjectName, entityName, this.entityByName.get(entityName));
            }
            return bodyBuilder.toString();
        });
        return builder.toString();
    }

    private String getMainObjectName(String className) {
        String candidate = StringUtils.uncapitalize((String)className);
        if (!className.equals(candidate)) {
            return candidate;
        }
        return "mainObj";
    }

    private void insertCreationMethod(StringBuilder builder, String entityName, EntityProperties entity) throws CodeGenerationException {
        if (!(entity instanceof Comment)) {
            builder.append(this.context.newLine()).append(this.context.newLine());
            String builderClassName = this.context.importClassName(BuilderClassProvider.findBuilderClass(entity.getClass()));
            builder.append("public ").append(builderClassName).append(" ").append(entityName).append("() {");
            this.context.incIndentation();
            builder.append(this.context.newLine());
            CodeEmitter<EntityProperties> codeEmitter = ValueEmitterFactory.emitterFor(entity);
            String entityCodeRightSide = codeEmitter.emitCode(this.context, (Object)entity);
            builder.append("final ").append(builderClassName);
            builder.append(String.format(" %s = %s;", entityName, entityCodeRightSide));
            builder.append(this.context.newLine());
            builder.append("return ").append(entityName).append(";");
            this.context.decIndentation();
            builder.append(this.context.newLine());
            builder.append("}");
        }
    }

    private void insertPublishingCode(StringBuilder builder, String classVariable, String entityName, EntityProperties entity) throws CodeGenerationException {
        if (entity instanceof Comment) {
            Comment comment = (Comment)entity;
            if (comment.newLineBefore) {
                builder.append(this.context.newLine());
            }
            builder.append("// ").append(comment.comment);
            if (comment.newLineAfter) {
                builder.append(this.context.newLine());
            }
        } else {
            CodeEmitter<EntityProperties> codeEmitter = ValueEmitterFactory.emitterFor(entity);
            String entityCodeRightSide = classVariable + "." + entityName + "()";
            builder.append("final ").append(this.context.importClassName(BuilderClassProvider.findBuilderClass(entity.getClass())));
            builder.append(String.format(" %s = %s;", entityName, entityCodeRightSide));
            builder.append(this.context.newLine());
            builder.append(String.format("bambooServer.publish(%s);", entityName));
        }
    }

    public String emitCode() throws CodeGenerationException {
        return this.emitCode("http://localhost:8085");
    }

    public String emitCode(@NotNull String bambooServerUrl) throws CodeGenerationException {
        return this.emitCode(bambooServerUrl, "", "PlanSpec");
    }

    public String emitCode(@NotNull String bambooServerUrl, @NotNull String packageName, @NotNull String className) throws CodeGenerationException {
        String main = this.buildCode(bambooServerUrl, className);
        StringBuilder codeBuilder = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)packageName)) {
            codeBuilder.append("package ").append(packageName).append(";\n\n");
        }
        for (String anImport : this.context.getImports()) {
            codeBuilder.append("import ").append(anImport).append(";\n");
        }
        codeBuilder.append("\n");
        codeBuilder.append(main);
        return codeBuilder.toString();
    }

    public static void main(String ... argv) {
        if (argv.length < 1) {
            System.out.println("File argument missing");
            return;
        }
        String filePath = argv[0];
        try {
            BambooSpecProperties o = (BambooSpecProperties)Yamlizator.getYaml().load((InputStream)new FileInputStream(new File(filePath)));
            String javaCode = new BambooSpecsGenerator(o.getRootEntity()).emitCode();
            System.out.print(javaCode);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Immutable
    public static class Comment
    implements EntityProperties {
        private String comment;
        private boolean newLineBefore;
        private boolean newLineAfter;

        private Comment() {
        }

        public Comment(String comment) {
            this(comment, true, true);
        }

        public Comment(String comment, boolean newLineBefore, boolean newLineAfter) {
            this.comment = comment;
            this.newLineBefore = newLineBefore;
            this.newLineAfter = newLineAfter;
        }

        public String toString() {
            return this.comment;
        }

        public void validate() {
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Comment comment1 = (Comment)o;
            return this.newLineBefore == comment1.newLineBefore && this.newLineAfter == comment1.newLineAfter && Objects.equals(this.comment, comment1.comment);
        }

        public int hashCode() {
            return Objects.hash(this.comment, this.newLineBefore, this.newLineAfter);
        }
    }

    public static interface CodeSupplier {
        public String generateCode() throws CodeGenerationException;
    }
}

