/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.model.task;

import com.atlassian.bamboo.specs.api.exceptions.PropertiesValidationException;
import com.atlassian.bamboo.specs.api.model.AtlassianModuleProperties;
import com.atlassian.bamboo.specs.api.model.plan.PlanIdentifierProperties;
import com.atlassian.bamboo.specs.api.model.plan.requirement.RequirementProperties;
import com.atlassian.bamboo.specs.api.model.task.TaskProperties;
import com.atlassian.bamboo.specs.api.validators.common.ImporterUtils;
import com.atlassian.bamboo.specs.api.validators.common.ValidationContext;
import com.atlassian.bamboo.specs.model.task.DownloadItemProperties;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Immutable
public final class ArtifactDownloaderTaskProperties
extends TaskProperties {
    private static final AtlassianModuleProperties ATLASSIAN_PLUGIN = new AtlassianModuleProperties("com.atlassian.bamboo.plugins.bamboo-artifact-downloader-plugin:artifactdownloadertask");
    private final PlanIdentifierProperties sourcePlan;
    private final List<DownloadItemProperties> artifacts;

    private ArtifactDownloaderTaskProperties() {
        this.sourcePlan = null;
        this.artifacts = Collections.emptyList();
    }

    public ArtifactDownloaderTaskProperties(@Nullable String description, boolean enabled, @Nullable PlanIdentifierProperties sourcePlan, @NotNull List<DownloadItemProperties> artifacts, @NotNull List<RequirementProperties> requirements) throws PropertiesValidationException {
        super(description, enabled, requirements);
        this.sourcePlan = sourcePlan;
        this.artifacts = Collections.unmodifiableList(new ArrayList<DownloadItemProperties>(artifacts));
        this.validate();
    }

    @Nullable
    public PlanIdentifierProperties getSourcePlan() {
        return this.sourcePlan;
    }

    public List<DownloadItemProperties> getArtifacts() {
        return this.artifacts;
    }

    @NotNull
    public AtlassianModuleProperties getAtlassianPlugin() {
        return ATLASSIAN_PLUGIN;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ArtifactDownloaderTaskProperties that = (ArtifactDownloaderTaskProperties)((Object)o);
        return Objects.equals(this.getSourcePlan(), that.getSourcePlan()) && Objects.equals(this.getArtifacts(), that.getArtifacts());
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getSourcePlan(), this.getArtifacts());
    }

    public void validate() {
        super.validate();
        ValidationContext context = ValidationContext.of((String)"Artifact downloader task");
        ImporterUtils.checkThat((ValidationContext)context, (this.artifacts != null && !this.artifacts.isEmpty() ? 1 : 0) != 0, (String)"No artifacts to download has been defined", (Object[])new Object[0]);
    }
}

