/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.util;

import com.atlassian.bamboo.specs.api.builders.RootEntityPropertiesBuilder;
import com.atlassian.bamboo.specs.api.builders.credentials.SharedCredentials;
import com.atlassian.bamboo.specs.api.builders.deployment.Deployment;
import com.atlassian.bamboo.specs.api.builders.permission.DeploymentPermissions;
import com.atlassian.bamboo.specs.api.builders.permission.EnvironmentPermissions;
import com.atlassian.bamboo.specs.api.builders.permission.PlanPermissions;
import com.atlassian.bamboo.specs.api.builders.plan.Plan;
import com.atlassian.bamboo.specs.api.builders.repository.VcsRepository;
import com.atlassian.bamboo.specs.util.UserPasswordCredentials;
import java.net.URI;

public final class RestTaskFactory {
    private RestTaskFactory() {
    }

    public static RestTask create(URI bambooServerUrl, UserPasswordCredentials userPasswordCredentials, RootEntityPropertiesBuilder entity, String payload) {
        String entityApiUrl = RestTaskFactory.getApiUrl(entity);
        URI restEntpointUri = bambooServerUrl.resolve(entityApiUrl);
        String humanReadableId = entity.humanReadableId();
        return new RestTask(restEntpointUri, userPasswordCredentials, humanReadableId, payload);
    }

    private static String getApiUrl(RootEntityPropertiesBuilder entity) {
        if (entity instanceof Plan) {
            return "rest/api/latest/import/plan";
        }
        if (entity instanceof Deployment) {
            return "rest/api/latest/import/deployment";
        }
        if (entity instanceof VcsRepository) {
            return "rest/api/latest/import/repository";
        }
        if (entity instanceof SharedCredentials) {
            return "rest/api/latest/import/sharedCredentials";
        }
        if (entity instanceof PlanPermissions) {
            return "rest/api/latest/import/plan/permission";
        }
        if (entity instanceof DeploymentPermissions) {
            return "rest/api/latest/import/deployment/permission";
        }
        if (entity instanceof EnvironmentPermissions) {
            return "rest/api/latest/import/deployment/environment/permission";
        }
        throw new IllegalArgumentException("Unknown entity " + entity.getClass());
    }

    public static final class RestTask {
        private final URI restEntpointUri;
        private final UserPasswordCredentials userPasswordCredentials;
        private final String humanReadableId;
        private final String yamlString;

        private RestTask(URI restEntpointUri, UserPasswordCredentials userPasswordCredentials, String humanReadableId, String yamlString) {
            this.restEntpointUri = restEntpointUri;
            this.userPasswordCredentials = userPasswordCredentials;
            this.humanReadableId = humanReadableId;
            this.yamlString = yamlString;
        }

        public URI getRestEntpointUri() {
            return this.restEntpointUri;
        }

        public UserPasswordCredentials getUserPasswordCredentials() {
            return this.userPasswordCredentials;
        }

        public String getHumanReadableId() {
            return this.humanReadableId;
        }

        public String getYamlString() {
            return this.yamlString;
        }
    }
}

