/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.util;

import com.atlassian.bamboo.specs.util.LogUtils;
import com.atlassian.bamboo.specs.util.Logger;
import com.atlassian.bamboo.specs.util.RestHelper;
import com.atlassian.bamboo.specs.util.UserPasswordCredentials;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class FileUserPasswordCredentials
implements UserPasswordCredentials {
    private static final Logger log = Logger.getLogger(FileUserPasswordCredentials.class);
    private static final String USERNAME_PROPERTY = "username";
    private static final String PASSWORD_PROPERTY = "password";
    private final String credentialsLocation;
    private final String username;
    private final String password;

    public FileUserPasswordCredentials() {
        this(".credentials");
    }

    public FileUserPasswordCredentials(@NotNull String credentialsLocation) {
        this.credentialsLocation = credentialsLocation;
        Properties properties = new Properties();
        try {
            File credentialsFile = new File(credentialsLocation);
            log.debug("Looking for credentials file: %s", credentialsFile.getAbsolutePath());
            if (credentialsFile.exists()) {
                log.debug("Credentials file found: %s", credentialsFile.getAbsolutePath());
                properties.load(new FileReader(credentialsFile));
            } else {
                log.debug("Credentials file not found under '%s', scanning JVM classpath for '%s'", credentialsFile.getAbsolutePath(), credentialsLocation);
                InputStream resourceAsStream = this.getClass().getClassLoader().getResourceAsStream(credentialsLocation);
                if (resourceAsStream == null) {
                    log.debug("Credentials not found on JVM classpath: %s", credentialsLocation);
                    log.info("Couldn't find credentials file '%s' to access Bamboo", credentialsLocation);
                    log.info("Please make sure that the path points to an existing file or to a resource available on JVM classpath", new Object[0]);
                    LogUtils.hintLogLevel(log, Logger.LogLevel.DEBUG);
                    throw new RuntimeException(String.format("Couldn't find credentials file: %s", credentialsLocation));
                }
                log.debug("Found credentials file on JVM classpath: %s", credentialsLocation);
                properties.load(RestHelper.class.getClassLoader().getResourceAsStream(credentialsLocation));
            }
        }
        catch (IOException e) {
            log.info("Couldn't read credentials file '%s' to access Bamboo", credentialsLocation);
            log.info("Please make sure that the file is accessible and that it is in correct format (Java properties)", new Object[0]);
            LogUtils.hintLogLevel(log, Logger.LogLevel.DEBUG);
            throw new RuntimeException(e);
        }
        this.username = this.getPropertyOrThrow(properties, USERNAME_PROPERTY, credentialsLocation);
        this.password = this.getPropertyOrThrow(properties, PASSWORD_PROPERTY, credentialsLocation);
    }

    private String getPropertyOrThrow(Properties properties, String propertyKey, String fileName) {
        String propertyValue = properties.getProperty(propertyKey);
        if (StringUtils.isEmpty((CharSequence)propertyValue)) {
            log.info("Property '%s' must be defined in credentials file '%s' to access Bamboo", propertyKey, fileName);
            log.info("Please make sure that the file is in correct format (Java properties)", new Object[0]);
            throw new RuntimeException(String.format("Property '%s' was not defined in credentials file: %s", propertyKey, fileName));
        }
        return propertyValue;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    public String toString() {
        return String.format("[type: 'file', location: '%s', username: '%s']", this.credentialsLocation, this.username);
    }
}

