/*
 * Decompiled with CFR 0.152.
 */
package com.aventstack.extentreports;

import com.aventstack.extentreports.ExtentReports;
import com.aventstack.extentreports.ExtentTest;
import com.aventstack.extentreports.MediaEntityBuilder;
import com.aventstack.extentreports.markuputils.CodeLanguage;
import com.aventstack.extentreports.markuputils.Markup;
import com.aventstack.extentreports.markuputils.MarkupHelper;
import com.aventstack.extentreports.reporter.ExtentAventReporter;
import com.aventstack.extentreports.reporter.ExtentBDDReporter;
import com.aventstack.extentreports.reporter.ExtentCardsReporter;
import com.aventstack.extentreports.reporter.ExtentEmailReporter;
import com.aventstack.extentreports.reporter.ExtentHtmlReporter;
import com.aventstack.extentreports.reporter.ExtentLoggerReporter;
import com.aventstack.extentreports.reporter.ExtentTabularReporter;
import java.io.IOException;

public class Main {
    public static void main(String[] args) throws IOException {
        ExtentAventReporter avent = new ExtentAventReporter("target/avent/");
        ExtentBDDReporter bdd = new ExtentBDDReporter("target/bdd/");
        ExtentCardsReporter cards = new ExtentCardsReporter("target/cards/");
        ExtentLoggerReporter logger = new ExtentLoggerReporter("target/logger/");
        ExtentTabularReporter tabular = new ExtentTabularReporter("target/tabular/");
        ExtentEmailReporter email = new ExtentEmailReporter("target/email/email.html");
        ExtentHtmlReporter html = new ExtentHtmlReporter("target/html/index.html");
        ExtentReports extent = new ExtentReports();
        extent.attachReporter(html, avent, cards, logger, tabular, bdd);
        String json = "{'foo' : 'bar', 'foos' : ['b','a','r'], 'bar' : {'foo':'bar', 'bar':false,'foobar':1234}}";
        String[][] data = new String[][]{{"Header1", "Header2", "Header3"}, {"Content.1.1", "Content.2.1", "Content.3.1"}, {"Content.1.2", "Content.2.2", "Content.3.2"}, {"Content.1.3", "Content.2.3", "Content.3.3"}, {"Content.1.4", "Content.2.4", "Content.3.4"}};
        Markup m = MarkupHelper.createTable(data);
        String code = "<root>\n    <Person>\n        <Name>Joe Doe</Name>\n        <StartDate>2007-01-01</StartDate>\n        <EndDate>2009-01-01</EndDate>\n        <Location>London</Location>\n    </Person>                    \n    <Person>\n        <Name>John Smith</Name>\n        <StartDate>2012-06-15</StartDate>\n        <EndDate>2014-12-31</EndDate>\n        <Location>Cardiff</Location>\n    </Person>\n</root>";
        ExtentTest test = extent.createTest("MediaTest", "A short description");
        test.pass(MarkupHelper.createCodeBlock(json, CodeLanguage.JSON));
        test.fail("fail");
        test.pass(MarkupHelper.createCodeBlock("<xml></xml>", CodeLanguage.XML));
        test.pass(MarkupHelper.createCodeBlock("<xml></xml>"));
        test.pass(MarkupHelper.createCodeBlock(code));
        test = extent.createTest("SkipNodes");
        test.createNode("SkipNode1").skip("skip").assignCategory("ExtentAPI", "Skip");
        test.createNode("SkipNode2").skip("skip").assignCategory("ExtentAPI", "Klov", "Skip");
        test = extent.createTest("PassSkipNodes");
        test.createNode("PassSkipNode1").skip("Passskip").assignCategory("ExtentAPI", "Skip");
        test.createNode("PassSkipNode2").pass("Passskip").assignCategory("ExtentAPI", "Klov", "Skip");
        test = extent.createTest("MediaTest", "A short description").assignDevice("sgs9");
        test.createNode("MediaTestNode1Level1").assignCategory("Failure").assignAuthor("Anshoo").assignDevice("sgs9+").addScreenCaptureFromPath("src/main/resources/1.png").fail("fail");
        ExtentTest node = test.createNode("MediaTestNode2Level1");
        ExtentTest subNode = node.createNode("MediaTestNode1Level2").addScreenCaptureFromPath("src/main/resources/1.png").fail("fail", MediaEntityBuilder.createScreenCaptureFromPath("src/main/resources/1.png").build());
        subNode = node.createNode("MediaTestNode2Level2").addScreenCaptureFromPath("src/main/resources/1.png").pass("pass");
        extent.createTest("CategoryTest").assignCategory("ExtentAPI").fail("fail");
        test = extent.createTest("MultipleCategoriesTest").assignCategory("ExtentAPI", "Klov").assignDevice("sgs9").pass("pass");
        extent.createTest("AuthorTest").assignAuthor("A").pass("Pass");
        test = extent.createTest("MultipleAuthorsTest").assignAuthor("A", "B").pass("pass");
        extent.createTest("MultipleCategoriesAndAuthorsTest").assignCategory("ExtentAPI", "Klov").assignAuthor("A", "B").pass("pass");
        extent.createTest("EventHierarchyTest").fatal("fatal").fail("fail").error("error").warning("warning").skip("skip").debug("debug").pass("pass").info("info");
        extent.createTest("ExceptionTest").fail(new RuntimeException("Runtime ex 1")).createNode("NodeLevel1").fail(new RuntimeException("Runtime ex 2"));
        extent.createTest("SkippedTest").skip("skipped");
        test = extent.createTest("MultipleCategoriesTest").assignCategory("ExtentAPI", "Klov").assignDevice("sgs9").pass("pass");
        extent.createTest("AuthorTest").assignAuthor("A").pass("Pass");
        test = extent.createTest("MultipleAuthorsTest").assignAuthor("A", "B").pass("pass");
        extent.createTest("MultipleCategoriesAndAuthorsTest").assignCategory("ExtentAPI", "Klov").assignAuthor("A", "B").pass("pass");
        extent.createTest("EventHierarchyTest").fatal("fatal").fail("fail").error("error").warning("warning").skip("skip").debug("debug").pass("pass").info("info");
        extent.createTest("ExceptionTest").fail(new RuntimeException("Runtime ex 1")).createNode("NodeLevel1").fail(new RuntimeException("Runtime ex 2"));
        extent.createTest("SkippedTest").skip("skipped");
        test = extent.createTest("MultipleCategoriesTest").assignCategory("ExtentAPI", "Klov").assignDevice("sgs9").pass("pass");
        extent.createTest("AuthorTest").assignAuthor("A").pass("Pass");
        test = extent.createTest("MultipleAuthorsTest").assignAuthor("A", "B").pass("pass");
        extent.createTest("MultipleCategoriesAndAuthorsTest").assignCategory("ExtentAPI", "Klov").assignAuthor("A", "B").pass("pass");
        extent.createTest("EventHierarchyTest").fatal("fatal").fail("fail").error("error").warning("warning").skip("skip").debug("debug").pass("pass").info("info");
        extent.createTest("ExceptionTest").fail(new RuntimeException("Runtime ex 1")).createNode("NodeLevel1").fail(new RuntimeException("Runtime ex 2"));
        extent.createTest("SkippedTest").skip("skipped");
        extent.setSystemInfo("sys", "value");
        extent.setSystemInfo("sys", "value");
        extent.flush();
    }
}

