/*
 * Decompiled with CFR 0.152.
 */
package com.aventstack.extentreports.model.context;

import com.aventstack.extentreports.Status;
import com.aventstack.extentreports.model.Attribute;
import com.aventstack.extentreports.model.Test;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class TestAttributeTestContext<T extends Attribute>
implements Serializable {
    private static final long serialVersionUID = 2595632998970711190L;
    private List<Test> tests = new ArrayList<Test>();
    private T attr;
    private int passed = 0;
    private int failed = 0;
    private int skipped = 0;
    private int others = 0;

    public TestAttributeTestContext(T attr) {
        this.attr = attr;
    }

    public void setTest(Test test) {
        this.updateTestStatusCounts(test);
        this.tests.add(test);
    }

    private void updateTestStatusCounts(Test test) {
        if (test.getStatus() == Status.PASS) {
            ++this.passed;
        } else if (test.getStatus() == Status.FAIL || test.getStatus() == Status.FATAL) {
            ++this.failed;
        } else if (test.getStatus() == Status.SKIP) {
            ++this.skipped;
        } else {
            ++this.others;
        }
    }

    public void refreshTestStatusCounts() {
        this.others = 0;
        this.skipped = 0;
        this.failed = 0;
        this.passed = 0;
        this.tests.forEach(this::updateTestStatusCounts);
    }

    public List<Test> getTests() {
        return this.tests;
    }

    public String getName() {
        return ((Attribute)this.attr).getName();
    }

    public int getPassed() {
        return this.passed;
    }

    public int getFailed() {
        return this.failed;
    }

    public int getSkipped() {
        return this.skipped;
    }

    public int getOthers() {
        return this.others;
    }

    public int size() {
        return this.tests == null ? 0 : this.tests.size();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public T getAttribute() {
        return this.attr;
    }
}

