/*
 * Decompiled with CFR 0.152.
 */
package com.aventstack.extentreports.config.external;

import com.aventstack.extentreports.config.external.ConfigLoadable;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.InstanceCreator;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.file.Files;

public class JsonConfigLoader<T>
implements ConfigLoadable<T> {
    private File f;
    private String json;
    private T instance;
    private InstanceCreator<T> creator;

    public JsonConfigLoader(T instance, File f) throws FileNotFoundException {
        if (f == null) {
            throw new IllegalArgumentException("File cannot be null");
        }
        if (!f.exists()) {
            throw new FileNotFoundException("File " + f.getAbsolutePath() + " could not be found");
        }
        this.init(instance);
        this.f = f;
    }

    public JsonConfigLoader(T instance, String json) {
        if (json == null || json.isEmpty()) {
            throw new IllegalArgumentException("Json input cannot be null or empty");
        }
        this.init(instance);
        this.json = json;
    }

    private void init(final T instance) {
        this.instance = instance;
        this.creator = new InstanceCreator<T>(){

            public T createInstance(Type type) {
                return instance;
            }
        };
    }

    @Override
    public void apply() {
        Gson gson = new GsonBuilder().registerTypeAdapter(this.instance.getClass(), this.creator).create();
        try {
            String json = this.f != null ? String.join((CharSequence)"\n", Files.readAllLines(this.f.toPath())) : this.json;
            this.instance = gson.fromJson(json, this.instance.getClass());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

