package com.aventstack.extentreports.gson;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

public class BddTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        if (!Class.class.isAssignableFrom(type.getRawType()))
            return null;
        return (TypeAdapter<T>) new BddTypeAdapter();
    }
}