/*
 * Decompiled with CFR 0.152.
 */
package com.aventstack.extentreports.model.context;

import com.aventstack.extentreports.model.NamedAttribute;
import com.aventstack.extentreports.model.Test;
import com.aventstack.extentreports.model.context.NamedAttributeContext;
import com.aventstack.extentreports.model.service.TestService;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;

public class NamedAttributeContextManager<T extends NamedAttribute> {
    private Set<NamedAttributeContext<T>> set = Collections.newSetFromMap(new ConcurrentHashMap());

    public synchronized void addContext(T attr, Test test) {
        Optional<NamedAttributeContext> opt = this.set.stream().filter(x -> ((NamedAttribute)x.getAttr()).getName().equals(attr.getName())).findAny();
        if (opt.isPresent()) {
            List<Test> list = opt.get().getTestList();
            if (!list.stream().anyMatch(t -> t.getId() == test.getId())) {
                list.add(test);
            }
        } else {
            this.set.add(new NamedAttributeContext<T>(attr, test));
        }
    }

    public void addContext(T attr, List<Test> testList) {
        testList.forEach(x -> this.addContext(attr, (Test)x));
    }

    public void removeTest(Test test) {
        Iterator<NamedAttributeContext<T>> iter = this.set.iterator();
        while (iter.hasNext()) {
            NamedAttributeContext<T> context = iter.next();
            TestService.deleteTest(context.getTestList(), test);
            if (!context.getTestList().isEmpty()) continue;
            iter.remove();
        }
    }

    public boolean hasItems() {
        return !this.set.isEmpty();
    }

    public void resetAll() {
        this.set.stream().forEach(x -> x.refresh());
    }

    @Generated
    public NamedAttributeContextManager() {
    }

    @Generated
    public Set<NamedAttributeContext<T>> getSet() {
        return this.set;
    }
}

