/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.lss;

import com.baidubce.AbstractBceClient;
import com.baidubce.BceClientConfiguration;
import com.baidubce.BceClientException;
import com.baidubce.http.HttpMethodName;
import com.baidubce.http.handler.BceErrorResponseHandler;
import com.baidubce.http.handler.BceJsonResponseHandler;
import com.baidubce.http.handler.BceMetadataResponseHandler;
import com.baidubce.http.handler.HttpResponseHandler;
import com.baidubce.internal.InternalRequest;
import com.baidubce.internal.RestartableInputStream;
import com.baidubce.model.AbstractBceRequest;
import com.baidubce.model.AbstractBceResponse;
import com.baidubce.services.lss.LssUtils;
import com.baidubce.services.lss.model.AntiLeech;
import com.baidubce.services.lss.model.Audio;
import com.baidubce.services.lss.model.Auth;
import com.baidubce.services.lss.model.CreateNotificationRequest;
import com.baidubce.services.lss.model.CreateNotificationResponse;
import com.baidubce.services.lss.model.CreatePresetRequest;
import com.baidubce.services.lss.model.CreatePresetResponse;
import com.baidubce.services.lss.model.CreateSessionRequest;
import com.baidubce.services.lss.model.CreateSessionResponse;
import com.baidubce.services.lss.model.CreateStreamRequest;
import com.baidubce.services.lss.model.CreateStreamResponse;
import com.baidubce.services.lss.model.DeleteNotificationRequest;
import com.baidubce.services.lss.model.DeleteNotificationResponse;
import com.baidubce.services.lss.model.DeletePresetRequest;
import com.baidubce.services.lss.model.DeletePresetResponse;
import com.baidubce.services.lss.model.DeleteSessionRequest;
import com.baidubce.services.lss.model.DeleteSessionResponse;
import com.baidubce.services.lss.model.DeleteStreamRequest;
import com.baidubce.services.lss.model.Encryption;
import com.baidubce.services.lss.model.GetAllDomainsBandwidthResponse;
import com.baidubce.services.lss.model.GetAllDomainsPlayCountResponse;
import com.baidubce.services.lss.model.GetAllDomainsStatisticsRequest;
import com.baidubce.services.lss.model.GetAllDomainsTrafficResponse;
import com.baidubce.services.lss.model.GetAppRequest;
import com.baidubce.services.lss.model.GetAppResponse;
import com.baidubce.services.lss.model.GetAppStreamRequest;
import com.baidubce.services.lss.model.GetAppStreamResponse;
import com.baidubce.services.lss.model.GetDomainStatisticsRequest;
import com.baidubce.services.lss.model.GetDomainStatisticsResponse;
import com.baidubce.services.lss.model.GetDomainSummaryStatisticsRequest;
import com.baidubce.services.lss.model.GetDomainSummaryStatisticsResponse;
import com.baidubce.services.lss.model.GetNotificationRequest;
import com.baidubce.services.lss.model.GetNotificationResponse;
import com.baidubce.services.lss.model.GetOneDomainBandwidthResponse;
import com.baidubce.services.lss.model.GetOneDomainPlayCountResponse;
import com.baidubce.services.lss.model.GetOneDomainStatisticsRequest;
import com.baidubce.services.lss.model.GetOneDomainTrafficResponse;
import com.baidubce.services.lss.model.GetPresetRequest;
import com.baidubce.services.lss.model.GetPresetResponse;
import com.baidubce.services.lss.model.GetRecordingRequest;
import com.baidubce.services.lss.model.GetRecordingResponse;
import com.baidubce.services.lss.model.GetSecurityPolicyRequest;
import com.baidubce.services.lss.model.GetSecurityPolicyResponse;
import com.baidubce.services.lss.model.GetSessionRequest;
import com.baidubce.services.lss.model.GetSessionResponse;
import com.baidubce.services.lss.model.GetSessionSourceInfoRequest;
import com.baidubce.services.lss.model.GetSessionSourceInfoResponse;
import com.baidubce.services.lss.model.GetSessionStatisticsRequest;
import com.baidubce.services.lss.model.GetSessionStatisticsResponse;
import com.baidubce.services.lss.model.GetStreamRequest;
import com.baidubce.services.lss.model.GetStreamResponse;
import com.baidubce.services.lss.model.GetStreamStatisticsRequest;
import com.baidubce.services.lss.model.GetStreamStatisticsResponse;
import com.baidubce.services.lss.model.Hls;
import com.baidubce.services.lss.model.InsertCuePointInnerRequest;
import com.baidubce.services.lss.model.InsertCuePointRequest;
import com.baidubce.services.lss.model.InsertCuePointResponse;
import com.baidubce.services.lss.model.ListAppRequest;
import com.baidubce.services.lss.model.ListAppResponse;
import com.baidubce.services.lss.model.ListAppStreamsRequest;
import com.baidubce.services.lss.model.ListAppStreamsResponse;
import com.baidubce.services.lss.model.ListDomainAppRequest;
import com.baidubce.services.lss.model.ListDomainAppResponse;
import com.baidubce.services.lss.model.ListDomainStatisticsRequest;
import com.baidubce.services.lss.model.ListDomainStatisticsResponse;
import com.baidubce.services.lss.model.ListNotificationsRequest;
import com.baidubce.services.lss.model.ListNotificationsResponse;
import com.baidubce.services.lss.model.ListPresetsRequest;
import com.baidubce.services.lss.model.ListPresetsResponse;
import com.baidubce.services.lss.model.ListRecordingsResponse;
import com.baidubce.services.lss.model.ListSecurityPoliciesRequest;
import com.baidubce.services.lss.model.ListSecurityPoliciesResponse;
import com.baidubce.services.lss.model.ListSessionsRequest;
import com.baidubce.services.lss.model.ListSessionsResponse;
import com.baidubce.services.lss.model.ListStreamRequest;
import com.baidubce.services.lss.model.ListStreamResponse;
import com.baidubce.services.lss.model.ListStreamStatisticsRequest;
import com.baidubce.services.lss.model.ListStreamStatisticsResponse;
import com.baidubce.services.lss.model.LivePublishInfo;
import com.baidubce.services.lss.model.LiveThumbnail;
import com.baidubce.services.lss.model.PauseAppStreamRequest;
import com.baidubce.services.lss.model.PauseAppStreamResponse;
import com.baidubce.services.lss.model.PauseDomainStreamRequest;
import com.baidubce.services.lss.model.PauseDomainStreamResponse;
import com.baidubce.services.lss.model.PauseSessionRequest;
import com.baidubce.services.lss.model.PauseSessionResponse;
import com.baidubce.services.lss.model.RefreshSessionRequest;
import com.baidubce.services.lss.model.RefreshSessionResponse;
import com.baidubce.services.lss.model.ResumeAppStreamRequest;
import com.baidubce.services.lss.model.ResumeAppStreamResponse;
import com.baidubce.services.lss.model.ResumeDomainStreamRequest;
import com.baidubce.services.lss.model.ResumeDomainStreamResponse;
import com.baidubce.services.lss.model.ResumeSessionRequest;
import com.baidubce.services.lss.model.ResumeSessionResponse;
import com.baidubce.services.lss.model.Rtmp;
import com.baidubce.services.lss.model.StartPullSessionRequest;
import com.baidubce.services.lss.model.StartPullSessionResponse;
import com.baidubce.services.lss.model.StartRecordingRequest;
import com.baidubce.services.lss.model.StartRecordingResponse;
import com.baidubce.services.lss.model.StopRecordingRequest;
import com.baidubce.services.lss.model.StopRecordingResponse;
import com.baidubce.services.lss.model.UpdateSecurityPolicyInnerRequest;
import com.baidubce.services.lss.model.UpdateSecurityPolicyRequest;
import com.baidubce.services.lss.model.UpdateSecurityPolicyResponse;
import com.baidubce.services.lss.model.UpdateStreamDestinationPushUrlRequest;
import com.baidubce.services.lss.model.UpdateStreamPresetsRequest;
import com.baidubce.services.lss.model.UpdateStreamPullUrlRequest;
import com.baidubce.services.lss.model.UpdateStreamRecordingRequest;
import com.baidubce.services.lss.model.UpdateStreamWatermarkRequest;
import com.baidubce.services.lss.model.Video;
import com.baidubce.services.lss.model.Watermarks;
import com.baidubce.util.HttpUtils;
import com.baidubce.util.JsonUtils;
import com.baidubce.util.Validate;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class LssClient
extends AbstractBceClient {
    private static final String VERSION = "v5";
    private static final String LIVE_PRESET = "preset";
    private static final String LIVE_SESSION = "session";
    private static final String LIVE_DOMAIN = "domain";
    private static final String LIVE_STREAM = "stream";
    private static final String LIVE_APP = "app";
    private static final String LIVE_NOTIFICATION = "notification";
    private static final String LIVE_SECURITY_POLICY = "securitypolicy";
    private static final String RECORDING = "recording";
    private static final String STATUS = "status";
    private static final String PAUSE = "pause";
    private static final String RESUME = "resume";
    private static final String REFRESH = "refresh";
    private static final String PULL = "pull";
    private static final String SOURCE_INFO = "sourceInfo";
    private static final String CUE_POINT = "cuepoint";
    private static final String STATISTICS = "statistics";
    private static HttpResponseHandler[] lssHandlers = new HttpResponseHandler[]{new BceMetadataResponseHandler(), new BceErrorResponseHandler(), new BceJsonResponseHandler()};

    public LssClient() {
        this(new BceClientConfiguration());
    }

    public LssClient(BceClientConfiguration clientConfiguration) {
        super(clientConfiguration, lssHandlers);
    }

    public CreatePresetResponse createPreset(CreatePresetRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        Validate.checkStringNotEmpty(request.getName(), "The parameter name should NOT be null or empty string.");
        if (request.getAudio() != null) {
            Validate.checkNotNull(request.getAudio().getBitRateInBps(), "The parameter bitRateInBps in audio should NOT be null.");
            Validate.checkIsTrue(request.getAudio().getBitRateInBps() > 0, "The audio's parameter bitRateInBps should be greater than zero.");
        }
        if (request.getVideo() != null) {
            Validate.checkNotNull(request.getVideo().getBitRateInBps(), "The parameter bitRateInBps in video should NOT be null.");
            Validate.checkIsTrue(request.getVideo().getBitRateInBps() > 0, "The video's parameter bitRateInBps should be greater than zero.");
            Validate.checkNotNull(request.getVideo().getMaxFrameRate(), "The parameter maxFrameRate in video should NOT be null.");
            Validate.checkIsTrue(request.getVideo().getMaxFrameRate().floatValue() > 0.0f, "The video's parameter maxFrameRate should be greater than zero.");
            Validate.checkNotNull(request.getVideo().getMaxWidthInPixel(), "The parameter maxWidthInPixel in video should NOT be null.");
            Validate.checkIsTrue(request.getVideo().getMaxWidthInPixel() > 0, "The video's parameter maxWidthInPixel should be greater than zero.");
            Validate.checkNotNull(request.getVideo().getMaxHeightInPixel(), "The parameter maxHeightInPixel in video should NOT be null.");
            Validate.checkIsTrue(request.getVideo().getMaxHeightInPixel() > 0, "The video's parameter maxHeightInPixel should be greater than zero.");
        }
        request.setThumbnail(null);
        request.setWatermarks(null);
        InternalRequest internalRequest = this.createRequest(HttpMethodName.POST, request, LIVE_PRESET);
        return this.invokeHttpClient(internalRequest, CreatePresetResponse.class);
    }

    public CreatePresetResponse createPreset(String name, String description, Audio audio, Video video, Hls hls, Rtmp rtmp, LiveThumbnail thumbnail, Watermarks watermarks) {
        CreatePresetRequest request = new CreatePresetRequest();
        request.setForwardOnly(false);
        request.setName(name);
        request.setDescription(description);
        request.setAudio(audio);
        request.setVideo(video);
        request.setHls(hls);
        request.setRtmp(rtmp);
        request.setThumbnail(thumbnail);
        request.setWatermarks(watermarks);
        return this.createPreset(request);
    }

    public CreatePresetResponse createForwardOnlyPreset(String name, String description, Hls hls, Rtmp rtmp, LiveThumbnail thumbnail, Watermarks watermarks) {
        CreatePresetRequest request = new CreatePresetRequest();
        request.setForwardOnly(true);
        request.setName(name);
        request.setDescription(description);
        request.setHls(hls);
        request.setRtmp(rtmp);
        request.setThumbnail(thumbnail);
        request.setWatermarks(watermarks);
        return this.createPreset(request);
    }

    public ListPresetsResponse listPresets() {
        ListPresetsRequest request = new ListPresetsRequest();
        InternalRequest internalRequest = this.createRequest(HttpMethodName.GET, request, LIVE_PRESET);
        return this.invokeHttpClient(internalRequest, ListPresetsResponse.class);
    }

    public GetPresetResponse getPreset(String name) {
        GetPresetRequest request = new GetPresetRequest();
        request.setName(name);
        return this.getPreset(request);
    }

    public GetPresetResponse getPreset(GetPresetRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        Validate.checkStringNotEmpty(request.getName(), "The parameter name should NOT be null or empty string.");
        InternalRequest internalRequest = this.createRequest(HttpMethodName.GET, request, LIVE_PRESET, request.getName());
        return this.invokeHttpClient(internalRequest, GetPresetResponse.class);
    }

    public DeletePresetResponse deletePreset(String name) {
        DeletePresetRequest request = new DeletePresetRequest();
        request.setName(name);
        return this.deletePreset(request);
    }

    public DeletePresetResponse deletePreset(DeletePresetRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        Validate.checkStringNotEmpty(request.getName(), "The parameter name should NOT be null or empty string.");
        InternalRequest internalRequest = this.createRequest(HttpMethodName.DELETE, request, LIVE_PRESET, request.getName());
        return this.invokeHttpClient(internalRequest, DeletePresetResponse.class);
    }

    public CreateSessionResponse createSession(String description, String preset, String notification, String securityPolicy, String recording, LivePublishInfo publish) {
        CreateSessionRequest request = new CreateSessionRequest();
        request.withPreset(preset).withDescription(description).withNotification(notification);
        request.withSecurityPolicy(securityPolicy).withPublish(publish).withRecording(recording);
        return this.createSession(request);
    }

    public CreateSessionResponse createSession(String description, List<String> presets, String notification, String securityPolicy, String recording, LivePublishInfo publish) {
        CreateSessionRequest request = new CreateSessionRequest();
        HashMap<String, String> presetMap = new HashMap<String, String>();
        for (int i = 0; i < presets.size(); ++i) {
            presetMap.put("L" + i, presets.get(i));
        }
        request.withPresets(presetMap).withDescription(description).withNotification(notification);
        request.withSecurityPolicy(securityPolicy).withPublish(publish).withRecording(recording);
        return this.createSession(request);
    }

    public CreateSessionResponse createSession(String description, List<String> presets, String notification, String securityPolicy, String recording, LivePublishInfo publish, String thumbnail, Watermarks watermarks) {
        CreateSessionRequest request = new CreateSessionRequest();
        HashMap<String, String> presetMap = new HashMap<String, String>();
        for (int i = 0; i < presets.size(); ++i) {
            presetMap.put("L" + i, presets.get(i));
        }
        request.withPresets(presetMap).withDescription(description).withNotification(notification);
        request.withSecurityPolicy(securityPolicy).withPublish(publish).withRecording(recording);
        request.withThumbnail(thumbnail).withWatermarks(watermarks);
        return this.createSession(request);
    }

    public CreateSessionResponse createSession(CreateSessionRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        if (request.getPreset() == null && request.getPresets() == null) {
            throw new IllegalArgumentException("The parameter preset and presets should NOT both be null or empty.");
        }
        InternalRequest internalRequest = this.createRequest(HttpMethodName.POST, request, LIVE_SESSION);
        return this.invokeHttpClient(internalRequest, CreateSessionResponse.class);
    }

    public ListSessionsResponse listSessions() {
        ListSessionsRequest request = new ListSessionsRequest();
        return this.listSessions(request);
    }

    public ListSessionsResponse listSessions(String status) {
        ListSessionsRequest request = new ListSessionsRequest().withStatus(status);
        return this.listSessions(request);
    }

    public ListSessionsResponse listSessions(ListSessionsRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        InternalRequest internalRequest = this.createRequest(HttpMethodName.GET, request, LIVE_SESSION);
        if (request.getStatus() != null) {
            Validate.checkStringNotEmpty(request.getStatus(), "The parameter status should NOT be empty string.");
            internalRequest.addParameter(STATUS, request.getStatus());
        }
        return this.invokeHttpClient(internalRequest, ListSessionsResponse.class);
    }

    public GetSessionResponse getSession(String sessionId) {
        GetSessionRequest request = new GetSessionRequest();
        request.setSessionId(sessionId);
        return this.getSession(request);
    }

    public GetSessionResponse getSessionWithToken(String sessionId, Integer timeoutInMinute) {
        GetSessionResponse getSessionResponse = this.getSession(sessionId);
        if (timeoutInMinute == null) {
            return getSessionResponse;
        }
        DateTime dateTime = new DateTime(DateTimeZone.UTC);
        DateTime expireTime = dateTime.plusMinutes(timeoutInMinute.intValue());
        DateTimeFormatter formatter = DateTimeFormat.forPattern((String)"yyyy-MM-dd'T'HH:mm:ss'Z'");
        String expire = formatter.print((ReadableInstant)expireTime);
        GetSecurityPolicyResponse getSecurityPolicyResponse = this.getSecurityPolicy(getSessionResponse.getSecurityPolicy());
        HashMap<String, String> hlsUrls = new HashMap<String, String>();
        HashMap<String, String> rtmpUrls = new HashMap<String, String>();
        HashMap<String, String> flvUrls = new HashMap<String, String>();
        if (getSecurityPolicyResponse.getAuth().getPlay().booleanValue()) {
            String line;
            if (getSessionResponse.getPlay().getHlsUrls() != null) {
                for (Map.Entry<String, String> entry : getSessionResponse.getPlay().getHlsUrls().entrySet()) {
                    line = entry.getKey();
                    String hlsUrl = entry.getValue();
                    if (hlsUrl == null) continue;
                    String hlsToken = null;
                    hlsToken = line.equals("L0") ? LssUtils.hmacSha256(String.format("/%s/live.m3u8;%s", sessionId, expire), getSecurityPolicyResponse.getAuth().getKey()) : LssUtils.hmacSha256(String.format("/%s-%s/live.m3u8;%s", sessionId, line, expire), getSecurityPolicyResponse.getAuth().getKey());
                    hlsUrl = hlsUrl.lastIndexOf(63) == -1 ? hlsUrl + String.format("?token=%s&expire=%s", hlsToken, expire) : hlsUrl + String.format("&token=%s&expire=%s", hlsToken, expire);
                    hlsUrls.put(line, hlsUrl);
                }
                getSessionResponse.getPlay().setHlsUrls(hlsUrls);
            } else if (getSessionResponse.getPlay().getHlsUrl() != null) {
                Object hlsUrl = getSessionResponse.getPlay().getHlsUrl();
                String string = LssUtils.hmacSha256(String.format("/%s/live.m3u8;%s", sessionId, expire), getSecurityPolicyResponse.getAuth().getKey());
                hlsUrl = ((String)hlsUrl).lastIndexOf(63) == -1 ? (String)hlsUrl + String.format("?token=%s&expire=%s", string, expire) : (String)hlsUrl + String.format("&token=%s&expire=%s", string, expire);
                getSessionResponse.getPlay().setHlsUrl((String)hlsUrl);
            }
            if (getSessionResponse.getPlay().getRtmpUrls() != null) {
                for (Map.Entry entry : getSessionResponse.getPlay().getRtmpUrls().entrySet()) {
                    line = (String)entry.getKey();
                    String rtmpUrl = (String)entry.getValue();
                    if (rtmpUrl != null) {
                        String rtmpToken = LssUtils.hmacSha256(String.format("%s;%s", sessionId, expire), getSecurityPolicyResponse.getAuth().getKey());
                        rtmpUrl = rtmpUrl + String.format("?token=%s&expire=%s", rtmpToken, expire);
                    }
                    rtmpUrls.put(line, rtmpUrl);
                }
                getSessionResponse.getPlay().setRtmpUrls(rtmpUrls);
            } else if (getSessionResponse.getPlay().getRtmpUrl() != null) {
                Object rtmpUrl = getSessionResponse.getPlay().getRtmpUrl();
                String string = LssUtils.hmacSha256(String.format("%s;%s", sessionId, expire), getSecurityPolicyResponse.getAuth().getKey());
                rtmpUrl = (String)rtmpUrl + String.format("?token=%s&expire=%s", string, expire);
                getSessionResponse.getPlay().setRtmpUrl((String)rtmpUrl);
            }
            if (getSessionResponse.getPlay().getFlvUrls() != null) {
                for (Map.Entry entry : getSessionResponse.getPlay().getFlvUrls().entrySet()) {
                    line = (String)entry.getKey();
                    String flvUrl = (String)entry.getValue();
                    if (flvUrl != null) {
                        String flvToken = LssUtils.hmacSha256(String.format("%s;%s", flvUrl, expire), getSecurityPolicyResponse.getAuth().getKey());
                        flvUrl = flvUrl + String.format("?token=%s&expire=%s", flvToken, expire);
                    }
                    flvUrls.put(line, flvUrl);
                }
                getSessionResponse.getPlay().setFlvUrls(flvUrls);
            } else if (getSessionResponse.getPlay().getFlvUrl() != null) {
                String flvUrl = getSessionResponse.getPlay().getFlvUrl();
                String string = LssUtils.hmacSha256(String.format("%s;%s", flvUrl, expire), getSecurityPolicyResponse.getAuth().getKey());
                flvUrl = flvUrl + String.format("?token=%s&expire=%s", string, expire);
                getSessionResponse.getPlay().setFlvUrl(flvUrl);
            }
        }
        if (getSecurityPolicyResponse.getAuth().getPush().booleanValue()) {
            String pushUrl = getSessionResponse.getPublish().getPushUrl();
            String string = LssUtils.hmacSha256(String.format("%s;%s", getSessionResponse.getPublish().getPushStream(), expire), getSecurityPolicyResponse.getAuth().getKey());
            pushUrl = pushUrl + String.format("?token=%s&expire=%s", string, expire);
            getSessionResponse.getPublish().setPushUrl(pushUrl);
        }
        return getSessionResponse;
    }

    public GetSessionResponse getSession(GetSessionRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        Validate.checkStringNotEmpty(request.getSessionId(), "The parameter sessionId should NOT be null or empty string.");
        InternalRequest internalRequest = this.createRequest(HttpMethodName.GET, request, LIVE_SESSION, request.getSessionId());
        return this.invokeHttpClient(internalRequest, GetSessionResponse.class);
    }

    public DeleteSessionResponse deleteSession(String sessionId) {
        DeleteSessionRequest request = new DeleteSessionRequest();
        request.setSessionId(sessionId);
        return this.deleteSession(request);
    }

    public DeleteSessionResponse deleteSession(DeleteSessionRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        Validate.checkStringNotEmpty(request.getSessionId(), "The parameter sessionId should NOT be null or empty string.");
        InternalRequest internalRequest = this.createRequest(HttpMethodName.DELETE, request, LIVE_SESSION, request.getSessionId());
        return this.invokeHttpClient(internalRequest, DeleteSessionResponse.class);
    }

    public PauseSessionResponse pauseSession(String sessionId) {
        PauseSessionRequest request = new PauseSessionRequest();
        request.setSessionId(sessionId);
        return this.pauseSession(request);
    }

    public PauseSessionResponse pauseSession(PauseSessionRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        Validate.checkStringNotEmpty(request.getSessionId(), "The parameter sessionId should NOT be null or empty string.");
        InternalRequest internalRequest = this.createRequest(HttpMethodName.PUT, request, LIVE_SESSION, request.getSessionId());
        internalRequest.addParameter(PAUSE, null);
        return this.invokeHttpClient(internalRequest, PauseSessionResponse.class);
    }

    public GetAppResponse queryApp(String app) {
        GetAppRequest request = new GetAppRequest();
        request.setApp(app);
        return this.queryApp(request);
    }

    public GetAppResponse queryApp(GetAppRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        Validate.checkStringNotEmpty(request.getApp(), "The parameter app should NOT be null or empty string.");
        InternalRequest internalRequest = this.createRequest(HttpMethodName.GET, request, LIVE_APP, request.getApp());
        return this.invokeHttpClient(internalRequest, GetAppResponse.class);
    }

    public ListAppResponse listApp() {
        ListAppRequest request = new ListAppRequest();
        return this.listApp(request);
    }

    public ListAppResponse listApp(ListAppRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        InternalRequest internalRequest = this.createRequest(HttpMethodName.GET, request, LIVE_APP);
        return this.invokeHttpClient(internalRequest, ListAppResponse.class);
    }

    public GetAppStreamResponse queryAppStream(String app, String stream) {
        GetAppStreamRequest request = new GetAppStreamRequest();
        request.setApp(app);
        request.setStream(stream);
        return this.queryAppStream(request);
    }

    public GetAppStreamResponse queryAppStream(GetAppStreamRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        Validate.checkStringNotEmpty(request.getApp(), "The parameter app should NOT be null or empty string.");
        Validate.checkStringNotEmpty(request.getStream(), "The parameter stream should NOT be null or empty string.");
        InternalRequest internalRequest = this.createRequest(HttpMethodName.GET, request, LIVE_APP, request.getApp(), LIVE_SESSION, request.getStream());
        return this.invokeHttpClient(internalRequest, GetAppStreamResponse.class);
    }

    public ListAppStreamsResponse listAppStreams(String app, String status) {
        ListAppStreamsRequest request = new ListAppStreamsRequest();
        request.setApp(app);
        request.setStatus(status);
        return this.listAppStreams(request);
    }

    public ListAppStreamsResponse listAppStreams(String app) {
        ListAppStreamsRequest request = new ListAppStreamsRequest();
        request.setApp(app);
        return this.listAppStreams(request);
    }

    public ListAppStreamsResponse listAppStreams(ListAppStreamsRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        Validate.checkStringNotEmpty(request.getApp(), "The parameter app should NOT be null or empty string.");
        InternalRequest internalRequest = this.createRequest(HttpMethodName.GET, request, LIVE_APP, request.getApp(), LIVE_SESSION);
        if (request.getStatus() != null) {
            internalRequest.addParameter(STATUS, request.getStatus());
        }
        return this.invokeHttpClient(internalRequest, ListAppStreamsResponse.class);
    }

    public PauseAppStreamResponse pauseAppStream(String app, String stream) {
        PauseAppStreamRequest pauseAppStreamRequest = new PauseAppStreamRequest();
        pauseAppStreamRequest.setApp(app);
        pauseAppStreamRequest.setStream(stream);
        return this.pauseAppStream(pauseAppStreamRequest);
    }

    public PauseAppStreamResponse pauseAppStream(PauseAppStreamRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        Validate.checkStringNotEmpty(request.getApp(), "The parameter app should NOT be null or empty string.");
        Validate.checkStringNotEmpty(request.getStream(), "The parameter stream should NOT be null or empty string.");
        InternalRequest internalRequest = this.createRequest(HttpMethodName.PUT, request, LIVE_APP, request.getApp(), LIVE_SESSION, request.getStream());
        internalRequest.addParameter(PAUSE, null);
        return this.invokeHttpClient(internalRequest, PauseAppStreamResponse.class);
    }

    public ResumeSessionResponse resumeSession(String sessionId) {
        ResumeSessionRequest request = new ResumeSessionRequest();
        request.setSessionId(sessionId);
        return this.resumeSession(request);
    }

    public ResumeSessionResponse resumeSession(ResumeSessionRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        Validate.checkStringNotEmpty(request.getSessionId(), "The parameter sessionId should NOT be null or empty string.");
        InternalRequest internalRequest = this.createRequest(HttpMethodName.PUT, request, LIVE_SESSION, request.getSessionId());
        internalRequest.addParameter(RESUME, null);
        return this.invokeHttpClient(internalRequest, ResumeSessionResponse.class);
    }

    public ResumeAppStreamResponse resumeAppStream(String app, String stream) {
        ResumeAppStreamRequest request = new ResumeAppStreamRequest();
        request.setApp(app);
        request.setStream(stream);
        return this.resumeAppStream(request);
    }

    public ResumeAppStreamResponse resumeAppStream(ResumeAppStreamRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        Validate.checkStringNotEmpty(request.getApp(), "The parameter app should NOT be null or empty string.");
        Validate.checkStringNotEmpty(request.getStream(), "The parameter stream should NOT be null or empty string.");
        InternalRequest internalRequest = this.createRequest(HttpMethodName.PUT, request, LIVE_APP, request.getApp(), LIVE_SESSION, request.getStream());
        internalRequest.addParameter(RESUME, null);
        return this.invokeHttpClient(internalRequest, ResumeAppStreamResponse.class);
    }

    public RefreshSessionResponse refreshSession(String sessionId) {
        RefreshSessionRequest request = new RefreshSessionRequest();
        request.setSessionId(sessionId);
        return this.refreshSession(request);
    }

    public RefreshSessionResponse refreshSession(RefreshSessionRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        Validate.checkStringNotEmpty(request.getSessionId(), "The parameter sessionId should NOT be null or empty string.");
        InternalRequest internalRequest = this.createRequest(HttpMethodName.PUT, request, LIVE_SESSION, request.getSessionId());
        internalRequest.addParameter(REFRESH, null);
        return this.invokeHttpClient(internalRequest, RefreshSessionResponse.class);
    }

    public StartPullSessionResponse startPullSession(String sessionId) {
        StartPullSessionRequest request = new StartPullSessionRequest().withSessionId(sessionId);
        return this.startPullSession(request);
    }

    public StartPullSessionResponse startPullSession(StartPullSessionRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        Validate.checkStringNotEmpty(request.getSessionId(), "The parameter sessionId should NOT be null or empty string.");
        InternalRequest internalRequest = this.createRequest(HttpMethodName.PUT, request, LIVE_SESSION, request.getSessionId());
        internalRequest.addParameter(PULL, null);
        return this.invokeHttpClient(internalRequest, StartPullSessionResponse.class);
    }

    public StartRecordingResponse startRecording(String sessionId, String recording) {
        Validate.checkStringNotEmpty(sessionId, "The parameter sessionId should NOT be null or empty string.");
        Validate.checkStringNotEmpty(recording, "The parameter recording should NOT be null or empty string.");
        StartRecordingRequest request = new StartRecordingRequest().withSessionId(sessionId);
        InternalRequest internalRequest = this.createRequest(HttpMethodName.PUT, request, LIVE_SESSION, sessionId);
        internalRequest.addParameter(RECORDING, recording);
        return this.invokeHttpClient(internalRequest, StartRecordingResponse.class);
    }

    public StopRecordingResponse stopRecording(String sessionId) {
        Validate.checkStringNotEmpty(sessionId, "The parameter sessionId should NOT be null or empty string.");
        StopRecordingRequest request = new StopRecordingRequest().withSessionId(sessionId);
        InternalRequest internalRequest = this.createRequest(HttpMethodName.PUT, request, LIVE_SESSION, sessionId);
        internalRequest.addParameter(RECORDING, null);
        return this.invokeHttpClient(internalRequest, StopRecordingResponse.class);
    }

    public GetSessionSourceInfoResponse getSessionSourceInfo(String sessionId) {
        Validate.checkStringNotEmpty(sessionId, "The parameter sessionId should NOT be null or empty string.");
        GetSessionSourceInfoRequest request = new GetSessionSourceInfoRequest();
        InternalRequest internalRequest = this.createRequest(HttpMethodName.GET, request, LIVE_SESSION, sessionId);
        internalRequest.addParameter(SOURCE_INFO, null);
        return this.invokeHttpClient(internalRequest, GetSessionSourceInfoResponse.class);
    }

    public InsertCuePointResponse insertCuePoint(String sessionId, String callback, Map<String, String> arguments) {
        InsertCuePointRequest request = new InsertCuePointRequest().withSessionId(sessionId).withCallback(callback).withArguments(arguments);
        return this.insertCuePoint(request);
    }

    public InsertCuePointResponse insertCuePoint(InsertCuePointRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        Validate.checkStringNotEmpty(request.getSessionId(), "The parameter sessionId should NOT be null or empty string.");
        Validate.checkStringNotEmpty(request.getCallback(), "The parameter callback should NOT be null or empty string.");
        InsertCuePointInnerRequest innerRequest = new InsertCuePointInnerRequest().withArguments(request.getArguments()).withCallback(request.getCallback());
        InternalRequest internalRequest = this.createRequest(HttpMethodName.PUT, innerRequest, LIVE_SESSION, request.getSessionId());
        internalRequest.addParameter(CUE_POINT, null);
        return this.invokeHttpClient(internalRequest, InsertCuePointResponse.class);
    }

    public GetRecordingResponse getRecording(String recording) {
        Validate.checkStringNotEmpty(recording, "The parameter recording should NOT be null or empty string.");
        GetRecordingRequest request = new GetRecordingRequest();
        InternalRequest internalRequest = this.createRequest(HttpMethodName.GET, request, RECORDING, recording);
        return this.invokeHttpClient(internalRequest, GetRecordingResponse.class);
    }

    public ListRecordingsResponse listRecordings() {
        GetRecordingRequest request = new GetRecordingRequest();
        InternalRequest internalRequest = this.createRequest(HttpMethodName.GET, request, RECORDING);
        return this.invokeHttpClient(internalRequest, ListRecordingsResponse.class);
    }

    public ListNotificationsResponse listNotifications() {
        ListNotificationsRequest request = new ListNotificationsRequest();
        InternalRequest internalRequest = this.createRequest(HttpMethodName.GET, request, LIVE_NOTIFICATION);
        return this.invokeHttpClient(internalRequest, ListNotificationsResponse.class);
    }

    public DeleteNotificationResponse deleteNotification(String name) {
        DeleteNotificationRequest request = new DeleteNotificationRequest();
        request.setName(name);
        return this.deleteNotification(request);
    }

    public DeleteNotificationResponse deleteNotification(DeleteNotificationRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        Validate.checkStringNotEmpty(request.getName(), "The parameter name should NOT be null or empty string.");
        InternalRequest internalRequest = this.createRequest(HttpMethodName.DELETE, request, LIVE_NOTIFICATION, request.getName());
        return this.invokeHttpClient(internalRequest, DeleteNotificationResponse.class);
    }

    public GetNotificationResponse getNotification(String name) {
        GetNotificationRequest request = new GetNotificationRequest();
        request.setName(name);
        return this.getNotification(request);
    }

    public GetNotificationResponse getNotification(GetNotificationRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        Validate.checkStringNotEmpty(request.getName(), "The parameter name should NOT be null or empty string.");
        InternalRequest internalRequest = this.createRequest(HttpMethodName.GET, request, LIVE_NOTIFICATION, request.getName());
        return this.invokeHttpClient(internalRequest, GetNotificationResponse.class);
    }

    public CreateNotificationResponse createNotification(String name, String endpoint) {
        CreateNotificationRequest request = new CreateNotificationRequest();
        request.withName(name).withEndpoint(endpoint);
        return this.createNotification(request);
    }

    public CreateNotificationResponse createNotification(CreateNotificationRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        Validate.checkStringNotEmpty(request.getName(), "The parameter name should NOT be null or empty string.");
        Validate.checkStringNotEmpty(request.getEndpoint(), "The parameter endpoint should NOT be null or empty string.");
        InternalRequest internalRequest = this.createRequest(HttpMethodName.POST, request, LIVE_NOTIFICATION);
        return this.invokeHttpClient(internalRequest, CreateNotificationResponse.class);
    }

    public ListSecurityPoliciesResponse listSecurityPolicies() {
        ListSecurityPoliciesRequest request = new ListSecurityPoliciesRequest();
        InternalRequest internalRequest = this.createRequest(HttpMethodName.GET, request, LIVE_SECURITY_POLICY);
        return this.invokeHttpClient(internalRequest, ListSecurityPoliciesResponse.class);
    }

    public GetSecurityPolicyResponse getSecurityPolicy(String name) {
        GetSecurityPolicyRequest request = new GetSecurityPolicyRequest();
        request.setName(name);
        return this.getSecurityPolicy(request);
    }

    public GetSecurityPolicyResponse getSecurityPolicy(GetSecurityPolicyRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        Validate.checkStringNotEmpty(request.getName(), "The parameter name should NOT be null or empty string.");
        InternalRequest internalRequest = this.createRequest(HttpMethodName.GET, request, LIVE_SECURITY_POLICY, request.getName());
        return this.invokeHttpClient(internalRequest, GetSecurityPolicyResponse.class);
    }

    public UpdateSecurityPolicyResponse updateSecurityPolicy(String name, Auth auth, AntiLeech antiLeech, Encryption encryption) {
        UpdateSecurityPolicyRequest request = new UpdateSecurityPolicyRequest();
        request.withName(name).withAuth(auth).withAntiLeech(antiLeech).withEncryption(encryption);
        return this.updateSecurityPolicy(request);
    }

    public UpdateSecurityPolicyResponse updateSecurityPolicy(UpdateSecurityPolicyRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        Validate.checkStringNotEmpty(request.getName(), "The parameter name should NOT be null or empty string.");
        UpdateSecurityPolicyInnerRequest innerRequest = new UpdateSecurityPolicyInnerRequest();
        innerRequest.withAuth(request.getAuth()).withAntiLeech(request.getAntiLeech()).withEncryption(request.getEncryption());
        InternalRequest internalRequest = this.createRequest(HttpMethodName.PUT, innerRequest, LIVE_SECURITY_POLICY, request.getName());
        return this.invokeHttpClient(internalRequest, UpdateSecurityPolicyResponse.class);
    }

    public GetSessionStatisticsResponse getSessionStatistics(String sessionId, String startDate, String endDate, Boolean aggregate) {
        GetSessionStatisticsRequest request = new GetSessionStatisticsRequest();
        request.withSessionId(sessionId).withStartDate(startDate).withEndDate(endDate).withAggregate(aggregate);
        return this.getSessionStatistics(request);
    }

    public GetSessionStatisticsResponse getSessionStatistics(GetSessionStatisticsRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        Validate.checkStringNotEmpty(request.getSessionId(), "The parameter sessionId should NOT be null or empty string.");
        InternalRequest internalRequest = this.createRequest(HttpMethodName.GET, request, STATISTICS, LIVE_SESSION, request.getSessionId());
        if (request.getStartDate() != null) {
            internalRequest.addParameter("startDate", request.getStartDate());
        }
        if (request.getEndDate() != null) {
            internalRequest.addParameter("endDate", request.getEndDate());
        }
        if (request.getAggregate() != null) {
            internalRequest.addParameter("aggregate", request.getAggregate().toString());
        }
        return this.invokeHttpClient(internalRequest, GetSessionStatisticsResponse.class);
    }

    public CreateStreamResponse createStream(CreateStreamRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        Validate.checkStringNotEmpty(request.getPlayDomain(), "playDomain should NOT be empty.");
        Validate.checkStringNotEmpty(request.getApp(), "app should NOT be empty.");
        Validate.checkNotNull(request.getPublish(), "publish should NOT be null.");
        Validate.checkStringNotEmpty(request.getPublish().getPushStream(), "pushStream should NOT be empty.");
        InternalRequest internalRequest = this.createRequest(HttpMethodName.POST, request, LIVE_DOMAIN, request.getPlayDomain(), LIVE_STREAM);
        return this.invokeHttpClient(internalRequest, CreateStreamResponse.class);
    }

    public CreateStreamResponse createStream(String playDomain, String app, String pushStream) {
        CreateStreamRequest request = new CreateStreamRequest();
        request.withPlayDomain(playDomain).withApp(app).withPublish(new CreateStreamRequest.PublishInfo().withPushStream(pushStream));
        return this.createStream(request);
    }

    public ListStreamResponse listStream(ListStreamRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        Validate.checkStringNotEmpty(request.getPlayDomain(), "playDomain should NOT be empty.");
        InternalRequest internalRequest = this.createRequest(HttpMethodName.GET, request, LIVE_DOMAIN, request.getPlayDomain(), LIVE_STREAM);
        if (request.getStatus() != null) {
            internalRequest.addParameter(STATUS, request.getStatus());
        }
        if (request.getMarker() != null) {
            internalRequest.addParameter("marker", request.getMarker());
        }
        if (request.getMaxSize() != null) {
            internalRequest.addParameter("maxSize", request.getMaxSize().toString());
        }
        return this.invokeHttpClient(internalRequest, ListStreamResponse.class);
    }

    public ListStreamResponse listStream(String playDomain) {
        ListStreamRequest request = new ListStreamRequest();
        request.setPlayDomain(playDomain);
        return this.listStream(request);
    }

    public ListDomainAppResponse listDomainApp(ListDomainAppRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        Validate.checkStringNotEmpty(request.getPlayDomain(), "playDomain should NOT be empty.");
        InternalRequest internalRequest = this.createRequest(HttpMethodName.GET, request, LIVE_DOMAIN, request.getPlayDomain(), LIVE_APP);
        return this.invokeHttpClient(internalRequest, ListDomainAppResponse.class);
    }

    public ListDomainAppResponse listDomainApp(String playDomain) {
        ListDomainAppRequest request = new ListDomainAppRequest();
        request.setPlayDomain(playDomain);
        return this.listDomainApp(request);
    }

    public GetStreamResponse getStream(GetStreamRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        Validate.checkStringNotEmpty(request.getPlayDomain(), "playDomain should NOT be empty.");
        Validate.checkStringNotEmpty(request.getApp(), "App should NOT be empty.");
        Validate.checkStringNotEmpty(request.getStream(), "Stream should NOT be empty.");
        InternalRequest internalRequest = this.createRequest(HttpMethodName.GET, request, LIVE_DOMAIN, request.getPlayDomain(), LIVE_APP, request.getApp(), LIVE_STREAM, request.getStream());
        return this.invokeHttpClient(internalRequest, GetStreamResponse.class);
    }

    public GetStreamResponse getStream(String domain, String app, String stream) {
        GetStreamRequest request = new GetStreamRequest();
        request.withPlayDomain(domain).withApp(app).withStream(stream);
        return this.getStream(request);
    }

    public PauseDomainStreamResponse pauseDomainStream(PauseDomainStreamRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        Validate.checkStringNotEmpty(request.getDomain(), "Domain should NOT be empty.");
        Validate.checkStringNotEmpty(request.getApp(), "App should NOT be empty.");
        Validate.checkStringNotEmpty(request.getStream(), "Stream should NOT be empty.");
        InternalRequest internalRequest = this.createRequest(HttpMethodName.PUT, request, LIVE_DOMAIN, request.getDomain(), LIVE_APP, request.getApp(), LIVE_STREAM, request.getStream());
        internalRequest.addParameter(PAUSE, null);
        return this.invokeHttpClient(internalRequest, PauseDomainStreamResponse.class);
    }

    public PauseDomainStreamResponse pauseDomainStream(String domain, String app, String stream) {
        PauseDomainStreamRequest request = new PauseDomainStreamRequest();
        request.withDomain(domain).withApp(app).withStream(stream);
        return this.pauseDomainStream(request);
    }

    public ResumeDomainStreamResponse resumeDomainStream(ResumeDomainStreamRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        Validate.checkStringNotEmpty(request.getDomain(), "Domain should NOT be empty.");
        Validate.checkStringNotEmpty(request.getApp(), "App should NOT be empty.");
        Validate.checkStringNotEmpty(request.getStream(), "Stream should NOT be empty.");
        InternalRequest internalRequest = this.createRequest(HttpMethodName.PUT, request, LIVE_DOMAIN, request.getDomain(), LIVE_APP, request.getApp(), LIVE_STREAM, request.getStream());
        internalRequest.addParameter(RESUME, null);
        return this.invokeHttpClient(internalRequest, ResumeDomainStreamResponse.class);
    }

    public ResumeDomainStreamResponse resumeDomainStream(String domain, String app, String stream) {
        ResumeDomainStreamRequest request = new ResumeDomainStreamRequest();
        request.withDomain(domain).withApp(app).withStream(stream);
        return this.resumeDomainStream(request);
    }

    public void deleteStream(DeleteStreamRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        Validate.checkStringNotEmpty(request.getDomain(), "Domain should NOT be empty.");
        Validate.checkStringNotEmpty(request.getApp(), "App should NOT be empty.");
        Validate.checkStringNotEmpty(request.getStream(), "Stream should NOT be empty.");
        InternalRequest internalRequest = this.createRequest(HttpMethodName.DELETE, request, LIVE_DOMAIN, request.getDomain(), LIVE_APP, request.getApp(), LIVE_STREAM, request.getStream());
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void deleteStream(String domain, String app, String stream) {
        DeleteStreamRequest request = new DeleteStreamRequest().withDomain(domain).withApp(app).withStream(stream);
        this.deleteStream(request);
    }

    public void updateStreamPresets(UpdateStreamPresetsRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        Validate.checkStringNotEmpty(request.getDomain(), "Domain should NOT be empty.");
        Validate.checkStringNotEmpty(request.getApp(), "App should NOT be empty");
        Validate.checkStringNotEmpty(request.getStream(), "Stream should NOT be empty.");
        InternalRequest internalRequest = this.createRequest(HttpMethodName.POST, request, LIVE_DOMAIN, request.getDomain(), LIVE_APP, request.getApp(), LIVE_STREAM, request.getStream());
        internalRequest.addParameter("presets", null);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void updateStreamPresets(String domain, String app, String stream, Map<String, String> presets) {
        UpdateStreamPresetsRequest request = new UpdateStreamPresetsRequest().withDomain(domain).withApp(app).withStream(stream).withPresets(presets);
        this.updateStreamPresets(request);
    }

    public void updateStreamRecording(UpdateStreamRecordingRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        Validate.checkStringNotEmpty(request.getDomain(), "Domain should NOT be empty.");
        Validate.checkStringNotEmpty(request.getApp(), "App should NOT be empty");
        Validate.checkStringNotEmpty(request.getStream(), "Stream should NOT be empty.");
        InternalRequest internalRequest = this.createRequest(HttpMethodName.PUT, request, LIVE_DOMAIN, request.getDomain(), LIVE_APP, request.getApp(), LIVE_STREAM, request.getStream());
        internalRequest.addParameter(RECORDING, request.getRecording());
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void updateStreamRecording(String domain, String app, String stream, String recording) {
        UpdateStreamRecordingRequest request = new UpdateStreamRecordingRequest().withDomain(domain).withApp(app).withStream(stream).withRecording(recording);
        this.updateStreamRecording(request);
    }

    public void updateStreamWatermark(UpdateStreamWatermarkRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        Validate.checkStringNotEmpty(request.getDomain(), "Domain should NOT be empty.");
        Validate.checkStringNotEmpty(request.getApp(), "App should NOT be empty");
        Validate.checkStringNotEmpty(request.getStream(), "Stream should NOT be empty.");
        InternalRequest internalRequest = this.createRequest(HttpMethodName.POST, request, LIVE_DOMAIN, request.getDomain(), LIVE_APP, request.getApp(), LIVE_STREAM, request.getStream());
        internalRequest.addParameter("watermark", null);
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void updateStreamWatermark(String domain, String app, String stream, Watermarks watermarks) {
        UpdateStreamWatermarkRequest request = new UpdateStreamWatermarkRequest().withDomain(domain).withApp(app).withStream(stream).withWatermarks(watermarks);
        this.updateStreamWatermark(request);
    }

    public void updateStreamPullUrl(UpdateStreamPullUrlRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        Validate.checkStringNotEmpty(request.getDomain(), "Domain should NOT be empty.");
        Validate.checkStringNotEmpty(request.getApp(), "App should NOT be empty");
        Validate.checkStringNotEmpty(request.getStream(), "Stream should NOT be empty.");
        Validate.checkStringNotEmpty(request.getPullUrl(), "PullUrl should NOT be empty.");
        InternalRequest internalRequest = this.createRequest(HttpMethodName.PUT, request, LIVE_DOMAIN, request.getDomain(), LIVE_APP, request.getApp(), LIVE_STREAM, request.getStream());
        internalRequest.addParameter("pullUrl", request.getPullUrl());
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void updateStreamPullUrl(String domain, String app, String stream, String pullUrl) {
        UpdateStreamPullUrlRequest request = new UpdateStreamPullUrlRequest().withDomain(domain).withApp(app).withStream(stream).withPullUrl(pullUrl);
        this.updateStreamPullUrl(request);
    }

    public void updateStreamDestinationPushUrl(UpdateStreamDestinationPushUrlRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        Validate.checkStringNotEmpty(request.getDomain(), "Domain should NOT be empty.");
        Validate.checkStringNotEmpty(request.getApp(), "App should NOT be empty");
        Validate.checkStringNotEmpty(request.getStream(), "Stream should NOT be empty.");
        InternalRequest internalRequest = this.createRequest(HttpMethodName.PUT, request, LIVE_DOMAIN, request.getDomain(), LIVE_APP, request.getApp(), LIVE_STREAM, request.getStream());
        internalRequest.addParameter("destinationPushUrl", request.getDestinationPushUrl());
        this.invokeHttpClient(internalRequest, AbstractBceResponse.class);
    }

    public void updateStreamDestinationPushUrl(String domain, String app, String stream, String destinationPushUrl) {
        UpdateStreamDestinationPushUrlRequest request = new UpdateStreamDestinationPushUrlRequest().withDomain(domain).withApp(app).withStream(stream).withDestinationPushUrl(destinationPushUrl);
        this.updateStreamDestinationPushUrl(request);
    }

    public GetDomainStatisticsResponse getDomainStatistics(GetDomainStatisticsRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        Validate.checkStringNotEmpty(request.getDomain(), "Domain should NOT be empty.");
        InternalRequest internalRequest = this.createRequest(HttpMethodName.GET, request, STATISTICS, LIVE_DOMAIN, request.getDomain());
        if (request.getStartDate() != null) {
            internalRequest.addParameter("startDate", request.getStartDate());
        }
        if (request.getEndDate() != null) {
            internalRequest.addParameter("endDate", request.getEndDate());
        }
        if (request.getAggregate() != null) {
            internalRequest.addParameter("aggregate", request.getAggregate().toString());
        }
        return this.invokeHttpClient(internalRequest, GetDomainStatisticsResponse.class);
    }

    public GetDomainStatisticsResponse getDomainStatistics(String domain) {
        GetDomainStatisticsRequest request = new GetDomainStatisticsRequest();
        request.setDomain(domain);
        return this.getDomainStatistics(request);
    }

    public GetDomainSummaryStatisticsResponse getDomainSummaryStatistics(GetDomainSummaryStatisticsRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        Validate.checkStringNotEmpty(request.getStartTime(), "startTime should NOT be empty.");
        InternalRequest internalRequest = this.createRequest(HttpMethodName.GET, request, STATISTICS, LIVE_DOMAIN, "summary");
        internalRequest.addParameter("startTime", request.getStartTime());
        if (request.getEndTime() != null) {
            internalRequest.addParameter("endTime", request.getEndTime());
        }
        return this.invokeHttpClient(internalRequest, GetDomainSummaryStatisticsResponse.class);
    }

    public GetDomainSummaryStatisticsResponse getDomainSummaryStatistics(String startTime, String endTime) {
        GetDomainSummaryStatisticsRequest request = new GetDomainSummaryStatisticsRequest();
        request.withStartTime(startTime).withEndTime(endTime);
        return this.getDomainSummaryStatistics(request);
    }

    public GetAllDomainsPlayCountResponse getAllDomainsPlayCount(GetAllDomainsStatisticsRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        Validate.checkStringNotEmpty(request.getTimeInterval(), "timeInterval should NOT be null");
        Validate.checkStringNotEmpty(request.getStartTime(), "startTime should NOT be null");
        InternalRequest internalRequest = this.createRequest(HttpMethodName.GET, request, STATISTICS, LIVE_DOMAIN, "playcount");
        internalRequest.addParameter("timeInterval", request.getTimeInterval());
        internalRequest.addParameter("startTime", request.getStartTime());
        if (request.getEndTime() != null) {
            internalRequest.addParameter("endTime", request.getEndTime());
        }
        return this.invokeHttpClient(internalRequest, GetAllDomainsPlayCountResponse.class);
    }

    public GetOneDomainPlayCountResponse getOneDomainPlayCount(GetOneDomainStatisticsRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        Validate.checkNotNull(request.getDomain(), "The domain parameter can not be null");
        Validate.checkStringNotEmpty(request.getTimeInterval(), "timeInterval should NOT be null");
        Validate.checkStringNotEmpty(request.getStartTime(), "startTime should NOT be null");
        InternalRequest internalRequest = this.createRequest(HttpMethodName.GET, request, STATISTICS, LIVE_DOMAIN, request.getDomain(), "playcount");
        internalRequest.addParameter("timeInterval", request.getTimeInterval());
        internalRequest.addParameter("startTime", request.getStartTime());
        if (request.getEndTime() != null) {
            internalRequest.addParameter("endTime", request.getEndTime());
        }
        return this.invokeHttpClient(internalRequest, GetOneDomainPlayCountResponse.class);
    }

    public GetAllDomainsBandwidthResponse getAllDomainsBandwidth(GetAllDomainsStatisticsRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        Validate.checkStringNotEmpty(request.getTimeInterval(), "timeInterval should NOT be null");
        Validate.checkStringNotEmpty(request.getStartTime(), "startTime should NOT be null");
        InternalRequest internalRequest = this.createRequest(HttpMethodName.GET, request, STATISTICS, LIVE_DOMAIN, "bandwidth");
        internalRequest.addParameter("timeInterval", request.getTimeInterval());
        internalRequest.addParameter("startTime", request.getStartTime());
        if (request.getEndTime() != null) {
            internalRequest.addParameter("endTime", request.getEndTime());
        }
        return this.invokeHttpClient(internalRequest, GetAllDomainsBandwidthResponse.class);
    }

    public GetOneDomainBandwidthResponse getOneDomainBandwidth(GetOneDomainStatisticsRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        Validate.checkStringNotEmpty(request.getDomain(), "The domain parameter can not be null");
        Validate.checkStringNotEmpty(request.getTimeInterval(), "timeInterval should NOT be null");
        Validate.checkStringNotEmpty(request.getStartTime(), "startTime should NOT be null");
        InternalRequest internalRequest = this.createRequest(HttpMethodName.GET, request, STATISTICS, LIVE_DOMAIN, request.getDomain(), "bandwidth");
        internalRequest.addParameter("timeInterval", request.getTimeInterval());
        internalRequest.addParameter("startTime", request.getStartTime());
        if (request.getEndTime() != null) {
            internalRequest.addParameter("endTime", request.getEndTime());
        }
        return this.invokeHttpClient(internalRequest, GetOneDomainBandwidthResponse.class);
    }

    public GetAllDomainsTrafficResponse getAllDomainsTraffic(GetAllDomainsStatisticsRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        Validate.checkStringNotEmpty(request.getTimeInterval(), "timeInterval should NOT be null");
        Validate.checkStringNotEmpty(request.getStartTime(), "startTime should NOT be null");
        InternalRequest internalRequest = this.createRequest(HttpMethodName.GET, request, STATISTICS, LIVE_DOMAIN, "traffic");
        internalRequest.addParameter("timeInterval", request.getTimeInterval());
        internalRequest.addParameter("startTime", request.getStartTime());
        if (request.getEndTime() != null) {
            internalRequest.addParameter("endTime", request.getEndTime());
        }
        return this.invokeHttpClient(internalRequest, GetAllDomainsTrafficResponse.class);
    }

    public GetOneDomainTrafficResponse getOneDomainTraffic(GetOneDomainStatisticsRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        Validate.checkStringNotEmpty(request.getDomain(), "The domain parameter can not be null");
        Validate.checkStringNotEmpty(request.getTimeInterval(), "timeInterval should NOT be null");
        Validate.checkStringNotEmpty(request.getStartTime(), "startTime should NOT be null");
        InternalRequest internalRequest = this.createRequest(HttpMethodName.GET, request, STATISTICS, LIVE_DOMAIN, request.getDomain(), "traffic");
        internalRequest.addParameter("timeInterval", request.getTimeInterval());
        internalRequest.addParameter("startTime", request.getStartTime());
        if (request.getEndTime() != null) {
            internalRequest.addParameter("endTime", request.getEndTime());
        }
        return this.invokeHttpClient(internalRequest, GetOneDomainTrafficResponse.class);
    }

    public ListDomainStatisticsResponse listDomainStatistics(ListDomainStatisticsRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        Validate.checkStringNotEmpty(request.getStartTime(), "startTime should NOT be empty");
        InternalRequest internalRequest = this.createRequest(HttpMethodName.GET, request, STATISTICS, LIVE_DOMAIN, "list");
        internalRequest.addParameter("startTime", request.getStartTime());
        if (request.getEndTime() != null) {
            internalRequest.addParameter("endTime", request.getEndTime());
        }
        if (request.getKeyword() != null) {
            internalRequest.addParameter("keyword", request.getKeyword());
        }
        if (request.getKeywordType() != null) {
            internalRequest.addParameter("keywordType", request.getKeywordType());
        }
        if (request.getOrderBy() != null) {
            internalRequest.addParameter("orderBy", request.getOrderBy());
        }
        return this.invokeHttpClient(internalRequest, ListDomainStatisticsResponse.class);
    }

    public ListStreamStatisticsResponse listStreamStatistics(ListStreamStatisticsRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        Validate.checkStringNotEmpty(request.getDomain(), "Domain should NOT be null");
        Validate.checkStringNotEmpty(request.getApp(), "App should NOT be null");
        Validate.checkStringNotEmpty(request.getStartTime(), "StartTime should NOT be null");
        InternalRequest internalRequest = this.createRequest(HttpMethodName.GET, request, STATISTICS, LIVE_DOMAIN, request.getDomain(), LIVE_STREAM);
        internalRequest.addParameter(LIVE_APP, request.getApp());
        internalRequest.addParameter("startTime", request.getStartTime());
        if (request.getEndTime() != null) {
            internalRequest.addParameter("endTime", request.getEndTime());
        }
        if (request.getKeyword() != null) {
            internalRequest.addParameter("keyword", request.getKeyword());
        }
        if (request.getKeywordType() != null) {
            internalRequest.addParameter("keywordType", request.getKeywordType());
        }
        if (request.getOrderBy() != null) {
            internalRequest.addParameter("orderBy", request.getOrderBy());
        }
        if (request.getPageNo() != null) {
            internalRequest.addParameter("pageNo", request.getPageNo().toString());
        }
        if (request.getPageSize() != null) {
            internalRequest.addParameter("pageSize", request.getPageSize().toString());
        }
        return this.invokeHttpClient(internalRequest, ListStreamStatisticsResponse.class);
    }

    public GetStreamStatisticsResponse getStreamStatistics(GetStreamStatisticsRequest request) {
        Validate.checkNotNull(request, "The parameter request should NOT be null.");
        Validate.checkStringNotEmpty(request.getDomain(), "Domain should NOT be null");
        Validate.checkStringNotEmpty(request.getApp(), "App should NOT be null");
        Validate.checkStringNotEmpty(request.getStream(), "Stream should NOT be null");
        InternalRequest internalRequest = this.createRequest(HttpMethodName.GET, request, STATISTICS, LIVE_DOMAIN, request.getDomain(), LIVE_APP, request.getApp(), LIVE_STREAM, request.getStream());
        if (request.getStartDate() != null) {
            internalRequest.addParameter("startDate", request.getStartDate());
        }
        if (request.getEndDate() != null) {
            internalRequest.addParameter("endDate", request.getEndDate());
        }
        if (request.getAggregate() != null) {
            internalRequest.addParameter("aggregate", request.getAggregate().toString());
        }
        return this.invokeHttpClient(internalRequest, GetStreamStatisticsResponse.class);
    }

    private InternalRequest createRequest(HttpMethodName httpMethod, AbstractBceRequest request, String ... pathVariables) {
        ArrayList<String> pathComponents = new ArrayList<String>();
        pathComponents.add(VERSION);
        if (pathVariables != null) {
            for (String pathVariable : pathVariables) {
                pathComponents.add(pathVariable);
            }
        }
        URI uri = HttpUtils.appendUri(this.getEndpoint(), pathComponents.toArray(new String[pathComponents.size()]));
        InternalRequest internalRequest = new InternalRequest(httpMethod, uri);
        internalRequest.setCredentials(request.getRequestCredentials());
        if (httpMethod == HttpMethodName.POST || httpMethod == HttpMethodName.PUT) {
            this.fillRequestPayload(internalRequest, request);
        }
        return internalRequest;
    }

    private InternalRequest fillRequestPayload(InternalRequest internalRequest, AbstractBceRequest request) {
        String strJson = JsonUtils.toJsonString(request);
        byte[] requestJson = null;
        try {
            requestJson = strJson.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new BceClientException("Unsupported encode.", e);
        }
        internalRequest.addHeader("Content-Length", String.valueOf(requestJson.length));
        internalRequest.addHeader("Content-Type", "application/json; charset=utf-8");
        internalRequest.setContent(RestartableInputStream.wrap(requestJson));
        return internalRequest;
    }
}

