/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.ros;

import com.baidubce.BceClientConfiguration;
import com.baidubce.http.HttpMethodName;
import com.baidubce.internal.InternalRequest;
import com.baidubce.services.ros.BaseRosClient;
import com.baidubce.services.ros.model.BaseResponse;
import com.baidubce.services.ros.model.problem.CreateOptimizationRequest;
import com.baidubce.services.ros.model.problem.CreateOrderedRequest;
import com.baidubce.services.ros.model.problem.CreateProblemRequest;
import com.baidubce.services.ros.model.problem.GetRouteResponse;
import com.baidubce.services.ros.model.problem.GetSolutionResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RosProblemClient
extends BaseRosClient {
    private static final Logger log = LoggerFactory.getLogger(RosProblemClient.class);
    private static final String PROBLEM_PATH_V1 = "/v1/scheduler/problem";
    private static final String PROBLEM_PATH_V2 = "/v2/scheduler/problem";

    public RosProblemClient() {
    }

    public RosProblemClient(BceClientConfiguration configuration) {
        super(configuration);
    }

    public RosProblemClient(String accessKey, String secretKey) {
        super(accessKey, secretKey);
    }

    public BaseResponse createSchedulerTask(CreateProblemRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, PROBLEM_PATH_V1);
        return this.invokeHttpClient(internalRequest, BaseResponse.class);
    }

    public GetSolutionResponse getSchedulerSolution(String taskId) {
        InternalRequest internalRequest = this.createRequest(null, HttpMethodName.GET, "/v2/scheduler/problem/" + taskId);
        return this.invokeHttpClient(internalRequest, GetSolutionResponse.class);
    }

    public BaseResponse createOptimizationTask(CreateOptimizationRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, "/v1/scheduler/problem/optimization");
        return this.invokeHttpClient(internalRequest, BaseResponse.class);
    }

    public GetRouteResponse getOptimizationRoute(String taskId) {
        InternalRequest internalRequest = this.createRequest(null, HttpMethodName.GET, "/v2/scheduler/problem/optimization/" + taskId);
        return this.invokeHttpClient(internalRequest, GetRouteResponse.class);
    }

    public BaseResponse createOrderedTask(CreateOrderedRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, "/v1/scheduler/problem/ordered");
        return this.invokeHttpClient(internalRequest, BaseResponse.class);
    }

    public GetRouteResponse getOrderedRoute(String taskId) {
        InternalRequest internalRequest = this.createRequest(null, HttpMethodName.GET, "/v2/scheduler/problem/ordered/" + taskId);
        return this.invokeHttpClient(internalRequest, GetRouteResponse.class);
    }
}

