/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus;

import com.baomidou.mybatisplus.MybatisXMLLanguageDriver;
import com.baomidou.mybatisplus.mapper.AutoMapper;
import com.baomidou.mybatisplus.mapper.AutoSqlInjector;
import com.baomidou.mybatisplus.spring.MybatisSqlSessionFactoryBean;
import java.util.Set;
import java.util.logging.Logger;
import org.apache.ibatis.io.ResolverUtil;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.scripting.LanguageDriver;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.SqlSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MybatisConfiguration
extends Configuration {
    protected final Logger logger = Logger.getLogger("MybatisConfiguration");

    public MybatisConfiguration() {
        System.err.println("mybatis-plus init success.");
    }

    public void addMappedStatement(MappedStatement ms) {
        if (this.mappedStatements.containsKey(ms.getId())) {
            this.logger.severe("mapper[" + ms.getId() + "] is ignored, because it's exists, maybe from xml file");
            return;
        }
        super.addMappedStatement(ms);
    }

    public void setDefaultScriptingLanguage(Class<?> driver) {
        if (driver == null) {
            driver = MybatisXMLLanguageDriver.class;
        }
        super.setDefaultScriptingLanguage(driver);
    }

    public LanguageDriver getDefaultScriptingLanuageInstance() {
        return this.languageRegistry.getDriver(MybatisXMLLanguageDriver.class);
    }

    public <T> T getMapper(Class<T> type, SqlSession sqlSession) {
        return (T)super.getMapper(type, sqlSession);
    }

    public <T> void addMapper(Class<T> type) {
        super.addMapper(type);
        if (!AutoMapper.class.isAssignableFrom(type)) {
            return;
        }
        new AutoSqlInjector(this, MybatisSqlSessionFactoryBean.DB_TYPE).inject(type);
    }

    public void addMappers(String packageName) {
        this.addMappers(packageName, Object.class);
    }

    public void addMappers(String packageName, Class<?> superType) {
        ResolverUtil resolverUtil = new ResolverUtil();
        resolverUtil.find((ResolverUtil.Test)new ResolverUtil.IsA(superType), packageName);
        Set mapperSet = resolverUtil.getClasses();
        for (Class mapperClass : mapperSet) {
            this.addMapper(mapperClass);
        }
    }
}

