/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.plugins.pagination;

import org.apache.ibatis.session.RowBounds;

public class Pagination
extends RowBounds {
    private int total;
    private int size;
    private int pages;
    private int current = 1;

    public Pagination() {
    }

    public Pagination(int current, int size) {
        super(Pagination.offsetCurrent(current, size), size);
        if (current > 1) {
            this.current = current;
        }
        this.size = size;
    }

    protected static int offsetCurrent(int current, int size) {
        if (current > 0) {
            return (current - 1) * size;
        }
        return 0;
    }

    public int getOffsetCurrent() {
        return Pagination.offsetCurrent(this.current, this.size);
    }

    public boolean hasPrevious() {
        return this.current > 1;
    }

    public boolean hasNext() {
        return this.current < this.pages;
    }

    public int getTotal() {
        return this.total;
    }

    public void setTotal(int total) {
        this.total = total;
        this.pages = this.total / this.size;
        if (this.total % this.size != 0) {
            ++this.pages;
        }
        if (this.current > this.pages) {
            this.current = 1;
        }
    }

    public int getSize() {
        return this.size;
    }

    public int getPages() {
        return this.pages;
    }

    public int getCurrent() {
        return this.current;
    }

    public String toString() {
        return "Pagination { total=" + this.total + " ,size=" + this.size + " ,pages=" + this.pages + " ,current=" + this.current + " }";
    }
}

