/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus;

import com.baomidou.mybatisplus.MybatisConfiguration;
import com.baomidou.mybatisplus.MybatisXMLConfigBuilder;
import com.baomidou.mybatisplus.mapper.DBType;
import com.baomidou.mybatisplus.mapper.ISqlInjector;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Properties;
import org.apache.ibatis.exceptions.ExceptionFactory;
import org.apache.ibatis.executor.ErrorContext;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.session.SqlSessionFactoryBuilder;

public class MybatisSessionFactoryBuilder
extends SqlSessionFactoryBuilder {
    public SqlSessionFactory build(Reader reader, String environment, Properties properties) {
        try {
            MybatisXMLConfigBuilder parser = new MybatisXMLConfigBuilder(reader, environment, properties);
            SqlSessionFactory sqlSessionFactory = this.build(parser.parse());
            return sqlSessionFactory;
        }
        catch (Exception e) {
            throw ExceptionFactory.wrapException((String)"Error building SqlSession.", (Exception)e);
        }
        finally {
            ErrorContext.instance().reset();
            try {
                reader.close();
            }
            catch (IOException e) {}
        }
    }

    public SqlSessionFactory build(InputStream inputStream, String environment, Properties properties) {
        try {
            MybatisXMLConfigBuilder parser = new MybatisXMLConfigBuilder(inputStream, environment, properties);
            SqlSessionFactory sqlSessionFactory = this.build(parser.parse());
            return sqlSessionFactory;
        }
        catch (Exception e) {
            throw ExceptionFactory.wrapException((String)"Error building SqlSession.", (Exception)e);
        }
        finally {
            ErrorContext.instance().reset();
            try {
                inputStream.close();
            }
            catch (IOException e) {}
        }
    }

    public void setDbType(String dbType) {
        MybatisConfiguration.DB_TYPE = DBType.getDBType(dbType);
    }

    public void setDbColumnUnderline(boolean dbColumnUnderline) {
        MybatisConfiguration.DB_COLUMN_UNDERLINE = dbColumnUnderline;
    }

    public void setSqlInjector(ISqlInjector sqlInjector) {
        MybatisConfiguration.SQL_INJECTOR = sqlInjector;
    }
}

