/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.toolkit;

import com.baomidou.mybatisplus.exceptions.MybatisPlusException;
import java.util.HashSet;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.type.classreading.CachingMetadataReaderFactory;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.util.ClassUtils;

public class PackageHelper {
    public static String[] convertTypeAliasesPackage(String typeAliasesPackage) {
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        CachingMetadataReaderFactory metadataReaderFactory = new CachingMetadataReaderFactory((ResourceLoader)resolver);
        String pkg = "classpath*:" + ClassUtils.convertClassNameToResourcePath((String)typeAliasesPackage) + "/*.class";
        try {
            HashSet<String> set = new HashSet<String>();
            Resource[] resources = resolver.getResources(pkg);
            if (resources != null && resources.length > 0) {
                MetadataReader metadataReader = null;
                for (Resource resource : resources) {
                    if (!resource.isReadable()) continue;
                    metadataReader = metadataReaderFactory.getMetadataReader(resource);
                    set.add(Class.forName(metadataReader.getClassMetadata().getClassName()).getPackage().getName());
                }
            }
            if (!set.isEmpty()) {
                return set.toArray(new String[0]);
            }
            throw new MybatisPlusException("not find typeAliasesPackage:" + pkg);
        }
        catch (Exception e) {
            throw new MybatisPlusException("not find typeAliasesPackage:" + pkg, e);
        }
    }
}

