/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.toolkit;

import com.baomidou.mybatisplus.MybatisConfiguration;
import com.baomidou.mybatisplus.annotations.TableField;
import com.baomidou.mybatisplus.annotations.TableId;
import com.baomidou.mybatisplus.annotations.TableName;
import com.baomidou.mybatisplus.exceptions.MybatisPlusException;
import com.baomidou.mybatisplus.toolkit.TableFieldInfo;
import com.baomidou.mybatisplus.toolkit.TableInfo;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableInfoHelper {
    private static Map<String, TableInfo> tableInfoCache = new ConcurrentHashMap<String, TableInfo>();

    public static synchronized TableInfo getTableInfo(Class<?> clazz) {
        TableInfo ti = tableInfoCache.get(clazz.getName());
        if (ti != null) {
            return ti;
        }
        List<Field> list = TableInfoHelper.getAllFields(clazz);
        TableInfo tableInfo = new TableInfo();
        TableName table = clazz.getAnnotation(TableName.class);
        if (table != null && table.value() != null && table.value().trim().length() > 0) {
            tableInfo.setTableName(table.value());
        } else {
            tableInfo.setTableName(TableInfoHelper.camelToUnderline(clazz.getSimpleName()));
        }
        ArrayList<TableFieldInfo> fieldList = new ArrayList<TableFieldInfo>();
        for (Field field : list) {
            TableId tableId = field.getAnnotation(TableId.class);
            if (tableId != null) {
                if (tableInfo.getKeyColumn() == null) {
                    tableInfo.setIdType(tableId.type());
                    if (tableId.value() != null && !"".equals(tableId.value())) {
                        tableInfo.setKeyColumn(tableId.value());
                        tableInfo.setKeyRelated(true);
                    } else if (MybatisConfiguration.DB_COLUMN_UNDERLINE) {
                        tableInfo.setKeyColumn(TableInfoHelper.camelToUnderline(field.getName()));
                    } else {
                        tableInfo.setKeyColumn(field.getName());
                    }
                    tableInfo.setKeyProperty(field.getName());
                    continue;
                }
                throw new MybatisPlusException("There must be only one, Discover multiple @TableId annotation in " + clazz);
            }
            TableField tableField = field.getAnnotation(TableField.class);
            if (tableField != null && tableField.value() != null && !"".equals(tableField.value())) {
                fieldList.add(new TableFieldInfo(true, tableField.value(), field.getName()));
                continue;
            }
            if (MybatisConfiguration.DB_COLUMN_UNDERLINE) {
                fieldList.add(new TableFieldInfo(true, TableInfoHelper.camelToUnderline(field.getName()), field.getName()));
                continue;
            }
            fieldList.add(new TableFieldInfo(field.getName()));
        }
        tableInfo.setFieldList(fieldList);
        if (tableInfo.getKeyColumn() == null) {
            throw new MybatisPlusException("Not found @TableId annotation in " + clazz);
        }
        tableInfoCache.put(clazz.getName(), tableInfo);
        return tableInfo;
    }

    private static String camelToUnderline(String param) {
        if (param == null || "".equals(param.trim())) {
            return "";
        }
        int len = param.length();
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            char c = param.charAt(i);
            if (Character.isUpperCase(c) && i > 0) {
                sb.append("_");
            }
            sb.append(Character.toLowerCase(c));
        }
        return sb.toString();
    }

    private static List<Field> getAllFields(Class<?> clazz) {
        Field[] fields;
        LinkedList<Field> result = new LinkedList<Field>();
        for (Field field : fields = clazz.getDeclaredFields()) {
            TableField tableField;
            if (Modifier.isTransient(field.getModifiers()) || (tableField = field.getAnnotation(TableField.class)) != null && !tableField.exist()) continue;
            result.add(field);
        }
        Class<?> superClass = clazz.getSuperclass();
        if (superClass.equals(Object.class)) {
            return result;
        }
        result.addAll(TableInfoHelper.getAllFields(superClass));
        return result;
    }
}

