/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.framework.service.impl;

import com.baomidou.framework.service.IService;
import com.baomidou.mybatisplus.annotations.IdType;
import com.baomidou.mybatisplus.exceptions.MybatisPlusException;
import com.baomidou.mybatisplus.mapper.BaseMapper;
import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.baomidou.mybatisplus.plugins.Page;
import com.baomidou.mybatisplus.toolkit.CollectionUtil;
import com.baomidou.mybatisplus.toolkit.ReflectionKit;
import com.baomidou.mybatisplus.toolkit.TableInfo;
import com.baomidou.mybatisplus.toolkit.TableInfoHelper;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.ibatis.jdbc.SQL;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.SqlSession;
import org.springframework.beans.factory.annotation.Autowired;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceImpl<M extends BaseMapper<T>, T>
implements IService<T> {
    protected static final Logger logger = Logger.getLogger("ServiceImpl");
    @Autowired
    protected M baseMapper;

    protected boolean retBool(int result) {
        return result >= 1;
    }

    @Override
    public boolean insertOrUpdate(T entity) {
        if (null != entity) {
            Class<?> cls = entity.getClass();
            TableInfo tableInfo = TableInfoHelper.getTableInfo(cls);
            if (null != tableInfo) {
                Object idVal = ReflectionKit.getMethodValue(cls, entity, tableInfo.getKeyProperty());
                if (null == idVal || "".equals(idVal)) {
                    return this.insert(entity);
                }
                if (IdType.INPUT == tableInfo.getIdType()) {
                    T entityValue = this.selectById((Serializable)idVal);
                    if (null != entityValue) {
                        return this.updateById(entity);
                    }
                    return this.insert(entity);
                }
                return this.updateById(entity);
            }
            throw new MybatisPlusException("Error:  Cannot execute. Could not find @TableId.");
        }
        return false;
    }

    @Override
    public boolean insert(T entity) {
        return this.retBool(this.baseMapper.insert(entity));
    }

    @Override
    public boolean insertBatch(List<T> entityList) {
        if (CollectionUtil.isEmpty(entityList)) {
            throw new IllegalArgumentException("Error: entityList must not be empty");
        }
        return this.retBool(this.baseMapper.insertBatch(entityList));
    }

    @Override
    public boolean insertBatch(List<T> entityList, int batchSize) {
        if (CollectionUtil.isEmpty(entityList)) {
            throw new IllegalArgumentException("Error: entityList must not be empty");
        }
        TableInfo tableInfo = TableInfoHelper.getTableInfo(this.currentModleClass());
        if (null == tableInfo) {
            throw new MybatisPlusException("Error: Cannot execute insertBatch Method, ClassGenricType not found .");
        }
        SqlSession batchSqlSession = tableInfo.getSqlMapper().getSqlSessionFactory().openSession(ExecutorType.BATCH, false);
        try {
            int size = entityList.size();
            for (int i = 0; i < size; ++i) {
                this.baseMapper.insert(entityList.get(i));
                if (i % batchSize != 0) continue;
                batchSqlSession.flushStatements();
            }
            batchSqlSession.flushStatements();
        }
        catch (Exception e) {
            logger.warning("Error: Cannot execute insertBatch Method. Cause:" + e);
            return false;
        }
        return true;
    }

    protected Class<T> currentModleClass() {
        return ReflectionKit.getSuperClassGenricType(this.getClass(), 1);
    }

    @Override
    public boolean insertSql(SQL sql, Object ... args) {
        return this.retBool(this.baseMapper.insertSql(sql, args));
    }

    @Override
    public boolean deleteById(Serializable id) {
        return this.retBool(this.baseMapper.deleteById(id));
    }

    @Override
    public boolean deleteByMap(Map<String, Object> columnMap) {
        return this.retBool(this.baseMapper.deleteByMap(columnMap));
    }

    @Override
    public boolean delete(EntityWrapper<T> entityWrapper) {
        return this.retBool(this.baseMapper.delete(entityWrapper));
    }

    @Override
    public boolean deleteBatchIds(List<? extends Serializable> idList) {
        return this.retBool(this.baseMapper.deleteBatchIds(idList));
    }

    @Override
    public boolean deleteSql(SQL sql, Object ... args) {
        return this.retBool(this.baseMapper.deleteSql(sql, args));
    }

    @Override
    public boolean updateById(T entity) {
        return this.retBool(this.baseMapper.updateById(entity));
    }

    @Override
    public boolean update(T entity, EntityWrapper<T> entityWrapper) {
        return this.retBool(this.baseMapper.update(entity, entityWrapper));
    }

    @Override
    public boolean updateBatchById(List<T> entityList) {
        return this.retBool(this.baseMapper.updateBatchById(entityList));
    }

    @Override
    public boolean updateSql(SQL sql, Object ... args) {
        return this.retBool(this.baseMapper.updateSql(sql, args));
    }

    @Override
    public T selectById(Serializable id) {
        return this.baseMapper.selectById(id);
    }

    @Override
    public List<T> selectBatchIds(List<? extends Serializable> idList) {
        return this.baseMapper.selectBatchIds(idList);
    }

    @Override
    public List<T> selectByMap(Map<String, Object> columnMap) {
        return this.baseMapper.selectByMap(columnMap);
    }

    @Override
    public T selectOne(EntityWrapper<T> entityWrapper) {
        List<T> list = this.baseMapper.selectList(entityWrapper);
        if (CollectionUtil.isNotEmpty(list)) {
            int size = list.size();
            if (size > 1) {
                logger.warning(String.format("Warn: selectOne Method There are  %s results.", size));
            }
            return list.get(0);
        }
        return null;
    }

    @Override
    public int selectCount(EntityWrapper<T> entityWrapper) {
        return this.baseMapper.selectCount(entityWrapper);
    }

    @Override
    public List<T> selectList(EntityWrapper<T> entityWrapper) {
        return this.baseMapper.selectList(entityWrapper);
    }

    @Override
    public List<T> selectListSql(SQL sql, Object ... args) {
        return this.baseMapper.selectListSql(sql, args);
    }

    @Override
    public Page<T> selectPage(Page<T> page) {
        page.setRecords(this.baseMapper.selectPage(page, null));
        return page;
    }

    @Override
    public Page<T> selectPage(Page<T> page, EntityWrapper<T> entityWrapper) {
        if (null != entityWrapper) {
            entityWrapper.orderBy(page.getOrderByField(), page.isAsc());
        }
        page.setRecords(this.baseMapper.selectPage(page, entityWrapper));
        return page;
    }

    @Override
    public Page<T> selectPageSql(Page<T> page, SQL sql, Object ... args) {
        page.setRecords(this.baseMapper.selectPageSql(page, sql, args));
        return page;
    }
}

